/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberQualifierUtil {
    private static final Logger LOG = Logger.getInstance(MemberQualifierUtil.class);

    @Nullable
    public static String findObjectExpression(@NotNull PsiReferenceExpression reference, @NotNull PsiMember member, @NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression generatedCall, @NotNull PsiElementFactory elementFactory) {
        if (reference == null) {
            MemberQualifierUtil.$$$reportNull$$$0(0);
        }
        if (member == null) {
            MemberQualifierUtil.$$$reportNull$$$0(1);
        }
        if (outerClass == null) {
            MemberQualifierUtil.$$$reportNull$$$0(2);
        }
        if (generatedCall == null) {
            MemberQualifierUtil.$$$reportNull$$$0(3);
        }
        if (elementFactory == null) {
            MemberQualifierUtil.$$$reportNull$$$0(4);
        }
        if (member.hasModifierProperty("static")) {
            return null;
        }
        PsiExpression qualifierExpression2 = reference.getQualifierExpression();
        if (qualifierExpression2 != null) {
            PsiType expressionType = qualifierExpression2.getType();
            return expressionType == null ? null : qualifierExpression2.getText();
        }
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        PsiElement resolveScope = resolveResult.getCurrentFileResolveScope();
        if (resolveScope instanceof PsiClass) {
            return MemberQualifierUtil.handleThisReference((PsiElement)reference, (PsiClass)resolveScope, outerClass, generatedCall, elementFactory);
        }
        return null;
    }

    @NotNull
    public static String handleThisReference(@NotNull PsiElement reference, @NotNull PsiClass referencedClass, @NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression generatedCall, @NotNull PsiElementFactory elementFactory) {
        String qualifiedName;
        if (reference == null) {
            MemberQualifierUtil.$$$reportNull$$$0(5);
        }
        if (referencedClass == null) {
            MemberQualifierUtil.$$$reportNull$$$0(6);
        }
        if (outerClass == null) {
            MemberQualifierUtil.$$$reportNull$$$0(7);
        }
        if (generatedCall == null) {
            MemberQualifierUtil.$$$reportNull$$$0(8);
        }
        if (elementFactory == null) {
            MemberQualifierUtil.$$$reportNull$$$0(9);
        }
        if ((qualifiedName = referencedClass.getQualifiedName()) == null) {
            LOG.warn("Anonymous and local classes are not supported yet");
        } else if (!PsiTreeUtil.isAncestor((PsiElement)outerClass, (PsiElement)referencedClass, (boolean)false)) {
            PsiType accessibleType = PsiReflectionAccessUtil.nearestAccessibleType((PsiType)PsiTypesUtil.getClassType((PsiClass)referencedClass));
            PsiMethod generatedMethod = (PsiMethod)PsiTreeUtil.findFirstParent((PsiElement)reference, x -> x instanceof PsiMethod && "invoke".equals(((PsiMethod)x).getName()));
            if (generatedMethod == null) {
                LOG.warn("Could not find method 'invoke' in the generated class");
                return "this";
            }
            PsiParameterList parameterList = generatedMethod.getParameterList();
            String referredObjectName = "outerContext" + parameterList.getParametersCount();
            parameterList.add((PsiElement)elementFactory.createParameter(referredObjectName, accessibleType));
            generatedCall.getArgumentList().add((PsiElement)elementFactory.createExpressionFromText(qualifiedName + ".this", null));
            String string = referredObjectName;
            if (string == null) {
                MemberQualifierUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        return "this";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedCall";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/MemberQualifierUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/MemberQualifierUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "handleThisReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findObjectExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleThisReference";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

