/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiReflectionAccessUtil {
    PsiReflectionAccessUtil() {
    }

    public static boolean isAccessibleMember(@NotNull PsiMember classMember) {
        if (classMember == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(0);
        }
        return classMember.hasModifierProperty("public") && PsiReflectionAccessUtil.isAccessible(classMember.getContainingClass());
    }

    @Contract(value="null -> false")
    public static boolean isAccessible(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (PsiUtil.isArrayClass((PsiElement)psiClass)) {
            return true;
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (containingFile instanceof PsiJavaFile && ((PsiJavaFile)containingFile).getPackageName().isEmpty()) {
            return false;
        }
        while (psiClass != null) {
            if (!psiClass.hasModifierProperty("public")) {
                return false;
            }
            psiClass = psiClass.getContainingClass();
        }
        return true;
    }

    public static boolean isAccessibleMethodReference(@NotNull PsiMethodReferenceExpression methodReference) {
        PsiElement method;
        if (methodReference == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(1);
        }
        if (!((method = methodReference.resolve()) instanceof PsiMethod)) {
            return true;
        }
        PsiTypeElement qualifierType = methodReference.getQualifierType();
        boolean qualifierAccessible = qualifierType == null || PsiReflectionAccessUtil.isAccessibleType(qualifierType.getType());
        return qualifierAccessible && PsiReflectionAccessUtil.isAccessibleMember((PsiMember)method);
    }

    @Nullable
    public static String extractQualifier(@NotNull PsiReferenceExpression referenceExpression) {
        PsiExpression qualifierExpression2;
        if (referenceExpression == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(2);
        }
        PsiType expressionType = (qualifierExpression2 = referenceExpression.getQualifierExpression()) != null ? qualifierExpression2.getType() : null;
        return expressionType == null ? null : qualifierExpression2.getText();
    }

    @Contract(value="null -> true")
    public static boolean isQualifierAccessible(@Nullable PsiExpression qualifierExpression2) {
        if (qualifierExpression2 == null) {
            return true;
        }
        PsiType type2 = qualifierExpression2.getType();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        return psiClass == null || PsiReflectionAccessUtil.isAccessible(psiClass);
    }

    @Nullable
    public static String getAccessibleReturnType(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        String expectedType;
        if (expression2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(3);
        }
        if ((expectedType = PsiReflectionAccessUtil.tryGetWeakestAccessibleExpectedType(expression2)) != null) {
            return expectedType;
        }
        return type2 != null ? PsiReflectionAccessUtil.nearestAccessibleType(type2).getCanonicalText() : null;
    }

    @Nullable
    public static String getAccessibleReturnType(@NotNull PsiExpression expression2, @Nullable PsiClass psiClass) {
        String expectedType;
        if (expression2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(4);
        }
        if ((expectedType = PsiReflectionAccessUtil.tryGetWeakestAccessibleExpectedType(expression2)) != null) {
            return expectedType;
        }
        return PsiReflectionAccessUtil.nearestAccessibleBaseClassName(psiClass);
    }

    @Nullable
    private static String tryGetWeakestAccessibleExpectedType(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(5);
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, true);
        PsiType realType = expression2.getType();
        if (expectedType != null && realType != null) {
            for (PsiType type2 : PsiReflectionAccessUtil.getAllAssignableSupertypes(realType, expectedType)) {
                if (!PsiReflectionAccessUtil.isAccessibleType(type2)) continue;
                return type2.getCanonicalText();
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiType> getAllAssignableSupertypes(@NotNull PsiType from, @NotNull PsiType to) {
        if (from == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(6);
        }
        if (to == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(7);
        }
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>();
        LinkedList<PsiType> queue = new LinkedList<PsiType>();
        queue.offer(from);
        while (!queue.isEmpty()) {
            PsiType type2 = (PsiType)queue.poll();
            if (!to.isAssignableFrom(type2)) continue;
            types.add(type2);
            Arrays.stream(type2.getSuperTypes()).forEach(queue::offer);
        }
        ArrayList<PsiType> result = new ArrayList<PsiType>(types);
        Collections.reverse(result);
        ArrayList<PsiType> arrayList = result;
        if (arrayList == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static String classForName(@NotNull String typeName) {
        if (typeName == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(9);
        }
        String string = TypeConversionUtil.isPrimitive((String)typeName) ? typeName + ".class" : "java.lang.Class.forName(\"" + typeName + "\")";
        if (string == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getUniqueMethodName(@NotNull PsiClass psiClass, @NotNull String prefix) {
        String name2;
        if (psiClass == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(11);
        }
        if (prefix == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(12);
        }
        if (!StringUtil.isJavaIdentifier((String)prefix)) {
            throw new IllegalArgumentException("prefix must be a correct java identifier: " + prefix);
        }
        int i = 1;
        do {
            name2 = prefix + i;
            ++i;
        } while (psiClass.findMethodsByName(name2, false).length != 0);
        String string = name2;
        if (string == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean isAccessibleType(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(14);
        }
        if (type2 instanceof PsiArrayType) {
            return PsiReflectionAccessUtil.isAccessibleType(type2.getDeepComponentType());
        }
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2) || PsiReflectionAccessUtil.isAccessible(PsiTypesUtil.getPsiClass((PsiType)type2));
    }

    @NotNull
    public static PsiType nearestAccessibleType(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(15);
        }
        while (!PsiReflectionAccessUtil.isAccessibleType(type2)) {
            type2 = type2.getSuperTypes()[0];
        }
        PsiType psiType = type2;
        if (psiType == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(16);
        }
        return psiType;
    }

    @Contract(value="null -> null")
    @Nullable
    private static String nearestAccessibleBaseClassName(@Nullable PsiClass psiClass) {
        while (psiClass != null && !PsiReflectionAccessUtil.isAccessible(psiClass)) {
            psiClass = psiClass.getSuperClass();
        }
        return psiClass == null ? null : psiClass.getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/PsiReflectionAccessUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/PsiReflectionAccessUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAssignableSupertypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "classForName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueMethodName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "nearestAccessibleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleMember";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleMethodReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractQualifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleReturnType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryGetWeakestAccessibleExpectedType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllAssignableSupertypes";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "classForName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueMethodName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "nearestAccessibleType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

