/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ConstructorDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldDeclarationDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.LocalVariableDeclarationDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.MethodDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ParameterDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ThisReferenceDescriptor;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionAccessorToEverything {
    private final PsiClass myOuterClass;
    private final PsiElementFactory myElementFactory;

    public ReflectionAccessorToEverything(@NotNull PsiClass generatedInnerClass, @NotNull PsiElementFactory elementFactory) {
        if (generatedInnerClass == null) {
            ReflectionAccessorToEverything.$$$reportNull$$$0(0);
        }
        if (elementFactory == null) {
            ReflectionAccessorToEverything.$$$reportNull$$$0(1);
        }
        this.myOuterClass = generatedInnerClass;
        this.myElementFactory = elementFactory;
    }

    public void grantAccessThroughReflection(@NotNull PsiMethodCallExpression generatedMethodCall) {
        if (generatedMethodCall == null) {
            ReflectionAccessorToEverything.$$$reportNull$$$0(2);
        }
        MyInaccessibleMethodReferencesVisitor methodReferencesVisitor = new MyInaccessibleMethodReferencesVisitor();
        this.myOuterClass.accept((PsiElementVisitor)methodReferencesVisitor);
        methodReferencesVisitor.replaceAll();
        MyInaccessibleItemsVisitor inaccessibleItemsVisitor = new MyInaccessibleItemsVisitor();
        this.myOuterClass.accept((PsiElementVisitor)inaccessibleItemsVisitor);
        inaccessibleItemsVisitor.myReplaceDescriptors.forEach(descriptor -> descriptor.replace(this.myOuterClass, this.myElementFactory, generatedMethodCall));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedInnerClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethodCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessorToEverything";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "grantAccessThroughReflection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInaccessibleMethodReferencesVisitor
    extends JavaRecursiveElementVisitor {
        private final List<PsiMethodReferenceExpression> myMethodReferencesToReplace = new ArrayList<PsiMethodReferenceExpression>();

        private MyInaccessibleMethodReferencesVisitor() {
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            if (!PsiReflectionAccessUtil.isAccessibleMethodReference(expression2)) {
                this.myMethodReferencesToReplace.add(expression2);
            }
        }

        private void replaceAll() {
            for (PsiMethodReferenceExpression referenceExpression : this.myMethodReferencesToReplace) {
                LambdaRefactoringUtil.convertMethodReferenceToLambda(referenceExpression, false, true);
            }
        }
    }

    private class MyInaccessibleItemsVisitor
    extends JavaRecursiveElementVisitor {
        private final List<ItemToReplaceDescriptor> myReplaceDescriptors = new ArrayList<ItemToReplaceDescriptor>();

        private MyInaccessibleItemsVisitor() {
        }

        public void visitParameter(PsiParameter parameter2) {
            super.visitParameter(parameter2);
            this.addIfNotNull(ParameterDescriptor.createIfInaccessible(parameter2));
        }

        public void visitThisExpression(PsiThisExpression expression2) {
            super.visitThisExpression(expression2);
            this.addIfNotNull(ThisReferenceDescriptor.createIfInaccessible(expression2));
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            super.visitDeclarationStatement(statement);
            this.addIfNotNull(LocalVariableDeclarationDescriptor.createIfInaccessible(statement));
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            this.addIfNotNull(FieldDeclarationDescriptor.createIfInaccessible(field));
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            this.addIfNotNull(FieldDescriptor.createIfInaccessible(ReflectionAccessorToEverything.this.myOuterClass, expression2));
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiAnonymousClass anonymousClass = expression2.getAnonymousClass();
            if (anonymousClass != null || expression2.getArrayInitializer() != null) {
                return;
            }
            this.addIfNotNull(ConstructorDescriptor.createIfInaccessible(expression2));
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            this.addIfNotNull(MethodDescriptor.createIfInaccessible(ReflectionAccessorToEverything.this.myOuterClass, expression2));
        }

        private void addIfNotNull(@Nullable ItemToReplaceDescriptor descriptor) {
            if (descriptor != null) {
                this.myReplaceDescriptors.add(descriptor);
            }
        }
    }
}

