/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.inline.InlineConstantFieldHandler;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineConstantFieldProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InlineConstantFieldProcessor.class);
    private PsiField myField;
    private final PsiReferenceExpression myRefExpr;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInCommentsAndStrings;
    private final boolean mySearchForTextOccurrences;
    private final boolean myDeleteDeclaration;
    private Map<Language, InlineHandler.Inliner> myInliners;

    public InlineConstantFieldProcessor(PsiField field, Project project, PsiReferenceExpression ref, boolean isInlineThisOnly) {
        this(field, project, ref, isInlineThisOnly, false, false, true);
    }

    public InlineConstantFieldProcessor(PsiField field, Project project, PsiReferenceExpression ref, boolean isInlineThisOnly, boolean searchInCommentsAndStrings, boolean searchForTextOccurrences, boolean isDeleteDeclaration) {
        super(project);
        this.myField = field;
        this.myRefExpr = ref;
        this.myInlineThisOnly = isInlineThisOnly;
        this.mySearchInCommentsAndStrings = searchInCommentsAndStrings;
        this.mySearchForTextOccurrences = searchForTextOccurrences;
        this.myDeleteDeclaration = isDeleteDeclaration;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(0);
        }
        return new InlineViewDescriptor((PsiElement)this.myField);
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(1);
        }
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        for (UsageInfo info : usages) {
            if (!(info instanceof NonCodeUsageInfo)) continue;
            return true;
        }
        return false;
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (this.myInlineThisOnly) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo((PsiQualifiedReferenceElement)this.myRefExpr)};
            if (usageInfoArray == null) {
                InlineConstantFieldProcessor.$$$reportNull$$$0(2);
            }
            return usageInfoArray;
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myField, (SearchScope)this.myRefactoringScope, (boolean)false)) {
            PsiElement element = ref.getElement();
            UsageInfo info = new UsageInfo(element);
            if (element instanceof PsiDocMethodOrFieldRef) {
                info = new UsageFromJavaDoc(element);
            }
            usages.add(info);
        }
        if (this.mySearchInCommentsAndStrings || this.mySearchForTextOccurrences) {
            String stringToSearch;
            NonCodeUsageInfoFactory nonCodeUsageFactory = new NonCodeUsageInfoFactory((PsiElement)this.myField, this.myField.getName()){

                public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                    if (usage == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)InlineConstantFieldProcessor.this.myField, (PsiElement)usage, (boolean)false)) {
                        return null;
                    }
                    return super.createUsageInfo(usage, startOffset, endOffset);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/inline/InlineConstantFieldProcessor$1", "createUsageInfo"));
                }
            };
            if (this.mySearchInCommentsAndStrings) {
                stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myField, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS);
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myField, (SearchScope)this.myRefactoringScope, (String)stringToSearch, usages, (UsageInfoFactory)nonCodeUsageFactory);
            }
            if (this.mySearchForTextOccurrences && this.myRefactoringScope instanceof GlobalSearchScope) {
                stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myField, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
                TextOccurrencesUtil.addTextOccurrences((PsiElement)this.myField, (String)stringToSearch, (GlobalSearchScope)((GlobalSearchScope)this.myRefactoringScope), usages, (UsageInfoFactory)nonCodeUsageFactory);
            }
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(elements.length == 1 && elements[0] instanceof PsiField);
        this.myField = (PsiField)elements[0];
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        PsiExpression initializer;
        if (usages == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((initializer = InlineConstantFieldHandler.getInitializer(this.myField)) != null);
        HashSet assignments = new HashSet();
        for (UsageInfo info : usages) {
            PsiElement element;
            if (info instanceof UsageFromJavaDoc || info instanceof NonCodeUsageInfo || (element = info.getElement()) == null) continue;
            try {
                if (element instanceof PsiExpression) {
                    this.inlineExpressionUsage((PsiExpression)element, initializer, assignments);
                    continue;
                }
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
                if (importStaticStatement != null) {
                    importStaticStatement.delete();
                    continue;
                }
                GenericInlineHandler.inlineReference((UsageInfo)info, (PsiElement)this.myField, this.myInliners);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        for (PsiAssignmentExpression assignment : assignments) {
            assignment.delete();
        }
        if (!this.myInlineThisOnly && this.myDeleteDeclaration && this.myField.isWritable()) {
            try {
                this.myField.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myField);
        return data;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.inline.field";
    }

    private void inlineExpressionUsage(PsiExpression expr2, PsiExpression initializer1, Set<? super PsiAssignmentExpression> assignments) throws IncorrectOperationException {
        if (expr2 instanceof PsiLiteralExpression) {
            return;
        }
        if (this.myField.isWritable()) {
            this.myField.normalizeDeclaration();
        }
        if (InlineConstantFieldProcessor.isAccessedForWriting(expr2)) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiAssignmentExpression.class);
            if (assignmentExpression != null) {
                assignments.add((PsiAssignmentExpression)assignmentExpression);
            }
            return;
        }
        PsiExpression thisAccessExpr = expr2 instanceof PsiReferenceExpression ? ((PsiReferenceExpression)expr2).getQualifierExpression() : null;
        PsiExpression invalidationCopy = thisAccessExpr != null ? (PsiExpression)thisAccessExpr.copy() : null;
        InlineUtil.inlineVariable((PsiVariable)this.myField, initializer1, (PsiJavaCodeReferenceElement)expr2, invalidationCopy);
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"inline.field.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myField)});
        if (string == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        PsiElement element;
        if (refUsages == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(7);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector();
        PsiExpression initializer = InlineConstantFieldHandler.getInitializer(this.myField);
        LOG.assertTrue(initializer != null);
        initializer.accept((PsiElementVisitor)collector);
        HashSet<PsiMember> referencedWithVisibility = collector.myReferencedMembers;
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)this.myField.getProject()).getResolveHelper();
        for (UsageInfo info : usagesIn) {
            element = info.getElement();
            if (element instanceof PsiExpression && (!this.myField.hasModifierProperty("final") || this.myInlineThisOnly) && InlineConstantFieldProcessor.isAccessedForWriting((PsiExpression)element)) {
                String message2 = JavaRefactoringBundle.message((String)"0.is.used.for.writing.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myField, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(element), (boolean)true)});
                conflicts.putValue((Object)element, (Object)message2);
            }
            for (PsiMember member : referencedWithVisibility) {
                if (resolveHelper.isAccessible(member, element, null)) continue;
                String message3 = JavaRefactoringBundle.message((String)"0.will.not.be.accessible.from.1.after.inlining", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(element), (boolean)true)});
                conflicts.putValue((Object)member, (Object)message3);
            }
        }
        this.myInliners = GenericInlineHandler.initInliners((PsiElement)this.myField, (UsageInfo[])usagesIn, (InlineHandler.Settings)new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return InlineConstantFieldProcessor.this.myInlineThisOnly;
            }
        }, (MultiMap)conflicts, (Language[])new Language[]{JavaLanguage.INSTANCE});
        if (!this.myInlineThisOnly) {
            for (UsageInfo info : usagesIn) {
                element = info.getElement();
                if (element instanceof PsiDocMethodOrFieldRef && !PsiTreeUtil.isAncestor((PsiElement)this.myField, (PsiElement)element, (boolean)false)) {
                    conflicts.putValue((Object)element, (Object)"Inlined field is used in javadoc");
                }
                if (!(element instanceof PsiLiteralExpression)) continue;
                if (!Stream.of(element.getReferences()).anyMatch(JavaLangClassMemberReference.class::isInstance)) continue;
                conflicts.putValue((Object)element, (Object)"Inlined field is used reflectively");
            }
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    private static boolean isAccessedForWriting(PsiExpression expr2) {
        while (expr2.getParent() instanceof PsiArrayAccessExpression) {
            expr2 = (PsiExpression)expr2.getParent();
        }
        return PsiUtil.isAccessedForWriting((PsiExpression)expr2);
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(8);
        }
        if (this.myInlineThisOnly) {
            List<PsiReferenceExpression> list = Collections.singletonList(this.myRefExpr);
            if (list == null) {
                InlineConstantFieldProcessor.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (!this.myField.isWritable()) {
            List list = Collections.emptyList();
            if (list == null) {
                InlineConstantFieldProcessor.$$$reportNull$$$0(10);
            }
            return list;
        }
        Collection collection = super.getElementsToWrite(descriptor);
        if (collection == null) {
            InlineConstantFieldProcessor.$$$reportNull$$$0(11);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineConstantFieldProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineConstantFieldProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UsageFromJavaDoc
    extends UsageInfo {
        private UsageFromJavaDoc(@NotNull PsiElement element) {
            if (element == null) {
                UsageFromJavaDoc.$$$reportNull$$$0(0);
            }
            super(element, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/inline/InlineConstantFieldProcessor$UsageFromJavaDoc", "<init>"));
        }
    }
}

