/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.AbstractInlineLocalDialog;

public class InlineLocalDialog
extends AbstractInlineLocalDialog {
    private final PsiVariable myVariable;
    private int myOccurrencesNumber = -1;

    public InlineLocalDialog(Project project, PsiVariable variable, PsiJavaCodeReferenceElement ref, int occurrencesCount) {
        super(project, (PsiElement)variable, (PsiReference)ref, occurrencesCount);
        this.myVariable = variable;
        this.myInvokedOnReference = ref != null;
        this.setTitle(InlineLocalDialog.getRefactoringName());
        this.myOccurrencesNumber = occurrencesCount;
        this.init();
    }

    protected String getNameLabelText() {
        return "Local variable " + this.myVariable.getName();
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.the.variable");
    }

    protected String getInlineAllText() {
        String occurrencesString = this.myOccurrencesNumber > -1 ? " (" + this.myOccurrencesNumber + " occurrence" + (this.myOccurrencesNumber == 1 ? ")" : "s)") : "";
        return RefactoringBundle.message((String)"all.references.and.remove.the.local") + occurrencesString;
    }

    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_LOCAL_THIS = this.isInlineThisOnly();
        }
        this.close(0);
    }

    protected String getHelpId() {
        return "refactoring.inlineVariable";
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_LOCAL_THIS;
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.variable.title");
    }
}

