/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterSettingsUI;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.NameSuggestionsManager;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ui.JBUI;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class IntroduceParameterDialog
extends RefactoringDialog {
    private static final String INTRODUCE_PARAMETER_LAMBDA = "introduce.parameter.lambda";
    private TypeSelector myTypeSelector;
    private NameSuggestionsManager myNameSuggestionsManager;
    private final Project myProject;
    private final PsiFile myFile;
    private final List<? extends UsageInfo> myClassMembersList;
    private final int myOccurenceNumber;
    private final PsiMethod myMethodToSearchFor;
    private final PsiMethod myMethodToReplaceIn;
    private final boolean myMustBeFinal;
    private final PsiExpression myExpression;
    private final PsiLocalVariable myLocalVar;
    protected JCheckBox myCbDeclareFinal;
    protected JCheckBox myCbCollapseToLambda;
    private NameSuggestionsField myParameterNameField;
    private final NameSuggestionsGenerator myNameSuggestionsGenerator;
    private final TypeSelectorManager myTypeSelectorManager;
    private NameSuggestionsField.DataChanged myParameterNameChangedListener;
    private final IntroduceParameterSettingsPanel myPanel;
    private boolean myHasWriteAccess;

    IntroduceParameterDialog(@NotNull Project project, @NotNull List<? extends UsageInfo> classMembersList, PsiExpression[] occurences, PsiLocalVariable onLocalVariable, PsiExpression onExpression, @NotNull NameSuggestionsGenerator generator, @NotNull TypeSelectorManager typeSelectorManager, @NotNull PsiMethod methodToSearchFor, @NotNull PsiMethod methodToReplaceIn, @NotNull TIntArrayList parametersToRemove, boolean mustBeFinal) {
        if (project == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(0);
        }
        if (classMembersList == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(1);
        }
        if (generator == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(2);
        }
        if (typeSelectorManager == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(3);
        }
        if (methodToSearchFor == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(4);
        }
        if (methodToReplaceIn == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(5);
        }
        if (parametersToRemove == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(6);
        }
        super(project, true);
        this.myPanel = new IntroduceParameterSettingsPanel(onLocalVariable, onExpression, methodToReplaceIn, parametersToRemove);
        this.myProject = project;
        this.myFile = methodToReplaceIn.getContainingFile();
        this.myClassMembersList = classMembersList;
        this.myOccurenceNumber = occurences.length;
        for (PsiExpression occurence : occurences) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)occurence)) continue;
            this.myHasWriteAccess = true;
            break;
        }
        this.myExpression = onExpression;
        this.myLocalVar = onLocalVariable;
        this.myMethodToReplaceIn = methodToReplaceIn;
        this.myMustBeFinal = mustBeFinal;
        this.myMethodToSearchFor = methodToSearchFor;
        this.myNameSuggestionsGenerator = generator;
        this.myTypeSelectorManager = typeSelectorManager;
        this.setTitle(IntroduceParameterDialog.getRefactoringName());
        this.init();
        this.myPanel.updateTypeSelector();
    }

    protected void dispose() {
        this.myParameterNameField.removeDataChangedListener(this.myParameterNameChangedListener);
        super.dispose();
    }

    private boolean isDeclareFinal() {
        return this.myCbDeclareFinal != null && this.myCbDeclareFinal.isSelected();
    }

    @NotNull
    private String getParameterName() {
        String string = this.myParameterNameField.getEnteredName().trim();
        if (string == null) {
            IntroduceParameterDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myParameterNameField.getFocusableComponent();
    }

    private PsiType getSelectedType() {
        return this.myTypeSelector.getSelectedType();
    }

    protected String getHelpId() {
        return "refactoring.introduceParameter";
    }

    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel2 = new JPanel(new GridBagLayout());
        gbConstraints.anchor = 17;
        gbConstraints.fill = 0;
        gbConstraints.gridx = 0;
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)0);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridy = 0;
        JLabel type2 = new JLabel(JavaRefactoringBundle.message((String)"parameter.of.type", (Object[])new Object[0]));
        panel2.add((Component)type2, gbConstraints);
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)8);
        ++gbConstraints.gridx;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myTypeSelector = this.myTypeSelectorManager.getTypeSelector();
        panel2.add((Component)this.myTypeSelector.getComponent(), gbConstraints);
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)8);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        gbConstraints.fill = 0;
        this.myParameterNameField = new NameSuggestionsField(this.myProject);
        JLabel nameLabel = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        nameLabel.setLabelFor(this.myParameterNameField.getComponent());
        panel2.add((Component)nameLabel, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)8);
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        panel2.add((Component)this.myParameterNameField.getComponent(), gbConstraints);
        this.myParameterNameChangedListener = () -> this.validateButtons();
        this.myParameterNameField.addDataChangedListener(this.myParameterNameChangedListener);
        this.myNameSuggestionsManager = new NameSuggestionsManager(this.myTypeSelector, this.myParameterNameField, this.myNameSuggestionsGenerator);
        this.myNameSuggestionsManager.setLabelsFor(type2, nameLabel);
        gbConstraints.gridx = 0;
        gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)4, (int)8);
        gbConstraints.gridwidth = 2;
        if (this.myOccurenceNumber > 1 && !this.myPanel.myIsInvokedOnDeclaration) {
            ++gbConstraints.gridy;
            this.myPanel.createOccurrencesCb(gbConstraints, panel2, this.myOccurenceNumber);
        }
        if (this.myPanel.myCbReplaceAllOccurences != null) {
            gbConstraints.insets = JBUI.insets((int)0, (int)16, (int)4, (int)8);
        }
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        this.myPanel.createLocalVariablePanel(gbConstraints, panel2, settings);
        this.myPanel.createRemoveParamsPanel(gbConstraints, panel2);
        gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)4, (int)8);
        ++gbConstraints.gridy;
        this.myCbDeclareFinal = new NonFocusableCheckBox(JavaRefactoringBundle.message((String)"declare.final", (Object[])new Object[0]));
        Boolean settingsFinals = settings.INTRODUCE_PARAMETER_CREATE_FINALS;
        this.myCbDeclareFinal.setSelected(settingsFinals == null ? JavaCodeStyleSettings.getInstance((PsiFile)this.myFile).GENERATE_FINAL_PARAMETERS : settingsFinals);
        panel2.add((Component)this.myCbDeclareFinal, gbConstraints);
        if (this.myMustBeFinal) {
            this.myCbDeclareFinal.setSelected(true);
            this.myCbDeclareFinal.setEnabled(false);
        } else if (this.myHasWriteAccess && this.myPanel.isReplaceAllOccurences()) {
            this.myCbDeclareFinal.setSelected(false);
            this.myCbDeclareFinal.setEnabled(false);
        }
        ++gbConstraints.gridy;
        this.myPanel.createDelegateCb(gbConstraints, panel2);
        this.myCbCollapseToLambda = new NonFocusableCheckBox(JavaRefactoringBundle.message((String)"introduce.parameter.convert.lambda", (Object[])new Object[0]));
        PsiAnonymousClass anonymClass = this.myExpression instanceof PsiNewExpression ? ((PsiNewExpression)this.myExpression).getAnonymousClass() : null;
        this.myCbCollapseToLambda.setVisible(anonymClass != null && AnonymousCanBeLambdaInspection.isLambdaForm(anonymClass, false, Collections.emptySet()));
        this.myCbCollapseToLambda.setSelected(PropertiesComponent.getInstance((Project)this.myProject).getBoolean(INTRODUCE_PARAMETER_LAMBDA, true));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbCollapseToLambda, gbConstraints);
        return panel2;
    }

    protected JComponent createCenterPanel() {
        if (Util.anyFieldsWithGettersPresent(this.myClassMembersList)) {
            return this.myPanel.createReplaceFieldsWithGettersPanel();
        }
        return null;
    }

    protected void doAction() {
        PsiExpression lambda2;
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        settings.INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS = this.myPanel.getReplaceFieldsWithGetters();
        if (this.myCbDeclareFinal != null && this.myCbDeclareFinal.isEnabled()) {
            settings.INTRODUCE_PARAMETER_CREATE_FINALS = this.myCbDeclareFinal.isSelected();
        }
        if (this.myCbCollapseToLambda.isVisible()) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(INTRODUCE_PARAMETER_LAMBDA, this.myCbCollapseToLambda.isSelected());
        }
        this.myPanel.saveSettings(settings);
        this.myNameSuggestionsManager.nameSelected();
        boolean isDeleteLocalVariable = false;
        PsiExpression parameterInitializer = this.myExpression;
        if (this.myLocalVar != null) {
            if (this.myPanel.isUseInitializer()) {
                parameterInitializer = this.myLocalVar.getInitializer();
            }
            isDeleteLocalVariable = this.myPanel.isDeleteLocalVariable();
        }
        PsiType selectedType = this.getSelectedType();
        IntroduceParameterProcessor processor = new IntroduceParameterProcessor(this.myProject, this.myMethodToReplaceIn, this.myMethodToSearchFor, parameterInitializer, this.myExpression, this.myLocalVar, isDeleteLocalVariable, this.getParameterName(), this.myPanel.isReplaceAllOccurences(), this.myPanel.getReplaceFieldsWithGetters(), this.isDeclareFinal(), this.myPanel.isGenerateDelegate(), selectedType, this.myPanel.getParametersToRemove());
        if (this.myCbCollapseToLambda.isVisible() && this.myCbCollapseToLambda.isSelected() && parameterInitializer != null && (lambda2 = AnonymousCanBeLambdaInspection.replaceAnonymousWithLambda((PsiElement)parameterInitializer, selectedType)) != null) {
            lambda2 = LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)lambda2);
            processor.setParameterInitializer(lambda2);
        }
        this.invokeRefactoring(processor);
    }

    private void updateFinalState() {
        if (this.myHasWriteAccess && this.myCbDeclareFinal != null) {
            this.myCbDeclareFinal.setEnabled(!this.myPanel.isReplaceAllOccurences());
            if (this.myPanel.isReplaceAllOccurences()) {
                this.myCbDeclareFinal.setSelected(false);
            }
        }
    }

    protected void canRun() throws ConfigurationException {
        String name2 = this.getParameterName();
        if (!PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name2)) {
            throw new ConfigurationException("'" + name2 + "' is invalid parameter name");
        }
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.myPanel.setReplaceAllOccurrences(replaceAllOccurrences);
    }

    public void setGenerateDelegate(boolean delegate) {
        this.myPanel.setGenerateDelegate(delegate);
    }

    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"introduce.parameter.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMembersList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSelectorManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodToSearchFor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodToReplaceIn";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToRemove";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class IntroduceParameterSettingsPanel
    extends IntroduceParameterSettingsUI {
        IntroduceParameterSettingsPanel(PsiLocalVariable onLocalVariable, PsiExpression onExpression, PsiMethod methodToReplaceIn, TIntArrayList parametersToRemove) {
            super(onLocalVariable, onExpression, methodToReplaceIn, parametersToRemove);
        }

        @Override
        protected TypeSelectorManager getTypeSelectionManager() {
            return IntroduceParameterDialog.this.myTypeSelectorManager;
        }

        @Override
        protected void updateControls(JCheckBox[] removeParamsCb) {
            super.updateControls(removeParamsCb);
            IntroduceParameterDialog.this.updateFinalState();
        }

        public void setGenerateDelegate(boolean delegate) {
            this.myCbGenerateDelegate.setSelected(delegate);
        }
    }
}

