/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.introduceParameter.ChangedMethodCallInfo;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.InternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUtil;
import com.intellij.refactoring.introduceParameter.IntroduceParameterViewDescriptor;
import com.intellij.refactoring.introduceParameter.JavaExpressionWrapper;
import com.intellij.refactoring.introduceParameter.JavaIntroduceParameterMethodUsagesProcessor;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.LocalVariableOccurrenceManager;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterProcessor
extends BaseRefactoringProcessor
implements IntroduceParameterData {
    private static final Logger LOG = Logger.getInstance(IntroduceParameterProcessor.class);
    private final PsiMethod myMethodToReplaceIn;
    private final PsiMethod myMethodToSearchFor;
    private PsiExpression myParameterInitializer;
    private final PsiExpression myExpressionToSearch;
    private final PsiLocalVariable myLocalVariable;
    private final boolean myRemoveLocalVariable;
    private final String myParameterName;
    private final boolean myReplaceAllOccurrences;
    private int myReplaceFieldsWithGetters;
    private final boolean myDeclareFinal;
    private final boolean myGenerateDelegate;
    private PsiType myForcedType;
    private final TIntArrayList myParametersToRemove;
    private final PsiManager myManager;
    private JavaExpressionWrapper myInitializerWrapper;
    private boolean myHasConflicts;

    public IntroduceParameterProcessor(@NotNull Project project, PsiMethod methodToReplaceIn, @NotNull PsiMethod methodToSearchFor, PsiExpression parameterInitializer, PsiExpression expressionToSearch, PsiLocalVariable localVariable, boolean removeLocalVariable, String parameterName, boolean replaceAllOccurrences, int replaceFieldsWithGetters, boolean declareFinal, boolean generateDelegate, PsiType forcedType, @NotNull TIntArrayList parametersToRemove) {
        if (project == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(0);
        }
        if (methodToSearchFor == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(1);
        }
        if (parametersToRemove == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myMethodToReplaceIn = methodToReplaceIn;
        this.myMethodToSearchFor = methodToSearchFor;
        this.myParameterInitializer = parameterInitializer;
        this.myExpressionToSearch = expressionToSearch;
        this.myLocalVariable = localVariable;
        this.myRemoveLocalVariable = removeLocalVariable;
        this.myParameterName = parameterName;
        this.myReplaceAllOccurrences = replaceAllOccurrences;
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
        this.myDeclareFinal = declareFinal;
        this.myGenerateDelegate = generateDelegate;
        this.myForcedType = forcedType;
        this.myManager = PsiManager.getInstance((Project)project);
        this.myParametersToRemove = parametersToRemove;
        this.myInitializerWrapper = expressionToSearch == null ? null : new JavaExpressionWrapper(expressionToSearch);
    }

    public void setParameterInitializer(PsiExpression parameterInitializer) {
        this.myParameterInitializer = parameterInitializer;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(3);
        }
        return new IntroduceParameterViewDescriptor(this.myMethodToSearchFor);
    }

    @Override
    @NotNull
    public PsiType getForcedType() {
        PsiType psiType = this.myForcedType;
        if (psiType == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(4);
        }
        return psiType;
    }

    private void setForcedType(PsiType forcedType) {
        this.myForcedType = forcedType;
    }

    @Override
    public int getReplaceFieldsWithGetters() {
        return this.myReplaceFieldsWithGetters;
    }

    public void setReplaceFieldsWithGetters(int replaceFieldsWithGetters) {
        this.myReplaceFieldsWithGetters = replaceFieldsWithGetters;
    }

    protected UsageInfo @NotNull [] findUsages() {
        PsiMethod[] overridingMethods;
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)this.myMethodToSearchFor).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            result.add(new UsageInfo((PsiElement)overridingMethod));
        }
        if (!this.myGenerateDelegate) {
            PsiElement[] refs;
            PsiElement[] psiElementArray = refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)this.myMethodToSearchFor, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject), (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY);
            int n = psiElementArray.length;
            for (int overridingMethod = 0; overridingMethod < n; ++overridingMethod) {
                PsiElement ref1 = psiElementArray[overridingMethod];
                PsiElement ref = ref1.getElement();
                if (ref instanceof PsiMethod && ((PsiMethod)ref).isConstructor()) {
                    DefaultConstructorImplicitUsageInfo implicitUsageInfo = new DefaultConstructorImplicitUsageInfo((PsiMethod)ref, ((PsiMethod)ref).getContainingClass(), this.myMethodToSearchFor);
                    result.add(implicitUsageInfo);
                    continue;
                }
                if (ref instanceof PsiClass) {
                    result.add(new NoConstructorClassUsageInfo((PsiClass)ref));
                    continue;
                }
                if (!IntroduceParameterUtil.insideMethodToBeReplaced(ref, this.myMethodToReplaceIn)) {
                    result.add(new ExternalUsageInfo(ref));
                    continue;
                }
                result.add(new ChangedMethodCallInfo(ref));
            }
        }
        if (this.myReplaceAllOccurrences) {
            for (PsiElement expr2 : this.getOccurrences()) {
                result.add(new InternalUsageInfo(expr2));
            }
        } else if (this.myExpressionToSearch != null && this.myExpressionToSearch.isValid()) {
            result.add(new InternalUsageInfo((PsiElement)this.myExpressionToSearch));
        }
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    protected PsiElement[] getOccurrences() {
        BaseOccurrenceManager occurrenceManager = this.myLocalVariable == null ? new ExpressionOccurrenceManager(this.myExpressionToSearch, (PsiElement)this.myMethodToReplaceIn, null) : new LocalVariableOccurrenceManager(this.myLocalVariable, null);
        return occurrenceManager.getOccurrences();
    }

    public boolean hasConflicts() {
        return this.myHasConflicts;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(6);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        AnySameNameVariables anySameNameVariables = new AnySameNameVariables();
        this.myMethodToReplaceIn.accept((PsiElementVisitor)anySameNameVariables);
        Pair<PsiElement, String> conflictPair = anySameNameVariables.getConflict();
        if (conflictPair != null) {
            conflicts.putValue(conflictPair.first, conflictPair.second);
        }
        if (!this.myGenerateDelegate) {
            this.detectAccessibilityConflicts(usagesIn, (MultiMap<PsiElement, String>)conflicts);
        }
        if (this.myParameterInitializer != null && !this.myMethodToReplaceIn.hasModifierProperty("private")) {
            AnySupers anySupers = new AnySupers();
            this.myParameterInitializer.accept((PsiElementVisitor)anySupers);
            if (anySupers.isResult()) {
                UsageInfo[] usageInfoArray = usagesIn;
                int n = usageInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    UsageInfo usageInfo = usageInfoArray[i];
                    PsiElement element = usageInfo.getElement();
                    if (element instanceof PsiMethod || usageInfo instanceof InternalUsageInfo || PsiTreeUtil.isAncestor((PsiElement)this.myMethodToReplaceIn.getContainingClass(), (PsiElement)element, (boolean)false)) continue;
                    String message2 = JavaRefactoringBundle.message((String)"parameter.initializer.contains.0.but.not.all.calls.to.method.are.in.its.class", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)"super")});
                    conflicts.putValue((Object)this.myParameterInitializer, (Object)message2);
                    break;
                }
            }
        }
        for (IntroduceParameterMethodUsagesProcessor processor : (IntroduceParameterMethodUsagesProcessor[])IntroduceParameterMethodUsagesProcessor.EP_NAME.getExtensions()) {
            processor.findConflicts(this, (UsageInfo[])refUsages.get(), (MultiMap<PsiElement, String>)conflicts);
        }
        this.myHasConflicts = !conflicts.isEmpty();
        return this.showConflicts(conflicts, usagesIn);
    }

    private void detectAccessibilityConflicts(UsageInfo[] usageArray, MultiMap<PsiElement, String> conflicts) {
        if (this.myParameterInitializer != null) {
            ReferencedElementsCollector collector = new ReferencedElementsCollector();
            this.myParameterInitializer.accept((PsiElementVisitor)collector);
            Set result = collector.myResult;
            if (!result.isEmpty()) {
                for (UsageInfo usageInfo : usageArray) {
                    if (!(usageInfo instanceof ExternalUsageInfo) || !IntroduceParameterUtil.isMethodUsage(usageInfo)) continue;
                    PsiElement place = usageInfo.getElement();
                    for (PsiElement element : result) {
                        if (element instanceof PsiField && this.myReplaceFieldsWithGetters != 0) {
                            PsiClass psiClass = ((PsiField)element).getContainingClass();
                            LOG.assertTrue(psiClass != null);
                            PsiMethod method = psiClass.findMethodBySignature(GenerateMembersUtil.generateGetterPrototype((PsiField)element), true);
                            if (method != null) {
                                element = method;
                            }
                        }
                        if (!(element instanceof PsiMember) || JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper().isAccessible((PsiMember)element, place, null)) continue;
                        String message2 = JavaRefactoringBundle.message((String)"0.is.not.accessible.from.1.value.for.introduced.parameter.in.that.method.call.will.be.incorrect", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(place), (boolean)true)});
                        conflicts.putValue((Object)element, (Object)message2);
                    }
                }
            }
        }
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.introduceParameter";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(new PsiElement[]{this.myLocalVariable, this.myExpressionToSearch});
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(7);
        }
        PsiParameter parameter2 = JavaIntroduceParameterMethodUsagesProcessor.getAnchorParameter(this.myMethodToReplaceIn);
        RefactoringEventData afterData = new RefactoringEventData();
        afterData.addElement((PsiElement)parameter2);
        return afterData;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(8);
        }
        try {
            PsiAnnotation annotation;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(this.myForcedType, this.myParameterInitializer, this.myLocalVariable);
            this.setForcedType(initializerType);
            if (this.myParameterInitializer == null) {
                LOG.assertTrue(this.myLocalVariable != null);
                this.myParameterInitializer = factory.createExpressionFromText(this.myLocalVariable.getName(), (PsiElement)this.myLocalVariable);
            } else if (this.myParameterInitializer instanceof PsiArrayInitializerExpression) {
                PsiExpression newExprArrayInitializer = RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)this.myParameterInitializer, initializerType);
                this.myParameterInitializer = (PsiExpression)this.myParameterInitializer.replace((PsiElement)newExprArrayInitializer);
            }
            this.myInitializerWrapper = new JavaExpressionWrapper(this.myParameterInitializer);
            IntroduceParameterUtil.processUsages(usages, this);
            if (this.myGenerateDelegate) {
                PsiCodeBlock block;
                PsiMethod method;
                this.generateDelegate(this.myMethodToReplaceIn);
                if (this.myMethodToReplaceIn != this.myMethodToSearchFor && (method = this.generateDelegate(this.myMethodToSearchFor)).getContainingClass().isInterface() && (block = method.getBody()) != null) {
                    block.delete();
                }
            }
            LOG.assertTrue(initializerType.isValid());
            FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(this.myParameterName, this.myMethodToReplaceIn.getBody());
            IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts(new UsageInfo((PsiElement)this.myMethodToReplaceIn), usages, this);
            if (this.myMethodToSearchFor != this.myMethodToReplaceIn) {
                IntroduceParameterUtil.changeMethodSignatureAndResolveFieldConflicts(new UsageInfo((PsiElement)this.myMethodToSearchFor), usages, this);
            } else if (this.myGenerateDelegate && this.myMethodToReplaceIn.findSuperMethods().length == 0 && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)this.myMethodToReplaceIn, (boolean)true, (String[])new String[]{Override.class.getName()})) != null) {
                annotation.delete();
            }
            ChangeContextUtil.clearContextInfo((PsiElement)this.myParameterInitializer);
            for (UsageInfo usage : usages) {
                PsiElement element;
                if (usage instanceof ChangedMethodCallInfo) {
                    element = usage.getElement();
                    this.processChangedMethodCall(element);
                    continue;
                }
                if (!(usage instanceof InternalUsageInfo)) continue;
                element = usage.getElement();
                if (element instanceof PsiExpression) {
                    element = RefactoringUtil.outermostParenthesizedExpression((PsiExpression)element);
                }
                if (element == null) continue;
                if (element.getParent() instanceof PsiExpressionStatement) {
                    element.getParent().delete();
                    continue;
                }
                PsiExpression newExpr = factory.createExpressionFromText(this.myParameterName, element);
                IntroduceVariableBase.replace((PsiExpression)element, newExpr, this.myProject);
            }
            if (this.myLocalVariable != null && this.myRemoveLocalVariable) {
                this.myLocalVariable.normalizeDeclaration();
                this.myLocalVariable.getParent().delete();
            }
            fieldConflictsResolver.fix();
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
        if (this.isReplaceDuplicates()) {
            ApplicationManager.getApplication().invokeLater(() -> this.processMethodsDuplicates(), this.myProject.getDisposed());
        }
    }

    protected boolean isReplaceDuplicates() {
        return true;
    }

    private void processMethodsDuplicates() {
        Runnable runnable = () -> {
            if (!this.myMethodToReplaceIn.isValid()) {
                return;
            }
            MethodDuplicatesHandler.invokeOnScope(this.myProject, Collections.singleton(this.myMethodToReplaceIn), new AnalysisScope(this.myMethodToReplaceIn.getContainingFile()), true);
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(runnable), JavaRefactoringBundle.message((String)"introduce.parameter.duplicates.progress", (Object[])new Object[0]), true, this.myProject);
    }

    private PsiMethod generateDelegate(PsiMethod methodToReplaceIn) throws IncorrectOperationException {
        PsiMethod delegate = (PsiMethod)methodToReplaceIn.copy();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        ChangeSignatureProcessor.makeEmptyBody(elementFactory, delegate);
        PsiCallExpression callExpression = ChangeSignatureProcessor.addDelegatingCallTemplate(delegate, delegate.getName());
        PsiExpressionList argumentList = callExpression.getArgumentList();
        assert (argumentList != null);
        PsiParameter[] psiParameters = methodToReplaceIn.getParameterList().getParameters();
        PsiParameter anchorParameter = IntroduceParameterProcessor.getAnchorParameter(methodToReplaceIn);
        if (psiParameters.length == 0) {
            argumentList.add((PsiElement)this.myParameterInitializer);
        } else {
            if (anchorParameter == null) {
                argumentList.add((PsiElement)this.myParameterInitializer);
            }
            for (int i = 0; i < psiParameters.length; ++i) {
                PsiParameter psiParameter = psiParameters[i];
                if (!this.myParametersToRemove.contains(i)) {
                    PsiExpression expression2 = elementFactory.createExpressionFromText(psiParameter.getName(), (PsiElement)delegate);
                    argumentList.add((PsiElement)expression2);
                }
                if (psiParameter != anchorParameter) continue;
                argumentList.add((PsiElement)this.myParameterInitializer);
            }
        }
        return (PsiMethod)methodToReplaceIn.getContainingClass().addBefore((PsiElement)delegate, (PsiElement)methodToReplaceIn);
    }

    static PsiType getInitializerType(PsiType forcedType, PsiExpression parameterInitializer, PsiLocalVariable localVariable) {
        PsiType initializerType;
        if (forcedType == null) {
            if (parameterInitializer == null) {
                if (localVariable == null) {
                    LOG.error("all null");
                    initializerType = null;
                } else {
                    initializerType = localVariable.getType();
                }
            } else {
                initializerType = localVariable == null ? RefactoringUtil.getTypeByExpressionWithExpectedType(parameterInitializer) : localVariable.getType();
            }
        } else {
            initializerType = forcedType;
        }
        return initializerType;
    }

    private void processChangedMethodCall(PsiElement element) throws IncorrectOperationException {
        if (element.getParent() instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element.getParent();
            if (this.myMethodToReplaceIn == this.myMethodToSearchFor && PsiTreeUtil.isAncestor((PsiElement)methodCall, (PsiElement)this.myParameterInitializer, (boolean)false)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)methodCall.getProject());
            PsiExpression expression2 = factory.createExpressionFromText(this.myParameterName, null);
            PsiExpressionList argList = methodCall.getArgumentList();
            PsiExpression[] exprs = argList.getExpressions();
            boolean first = false;
            PsiExpression anchor = null;
            if (this.myMethodToSearchFor.isVarArgs()) {
                int oldParamCount = this.myMethodToSearchFor.getParameterList().getParametersCount() - 1;
                if (exprs.length >= oldParamCount) {
                    if (oldParamCount > 1) {
                        anchor = exprs[oldParamCount - 2];
                    } else {
                        first = true;
                        anchor = null;
                    }
                } else {
                    anchor = exprs[exprs.length - 1];
                }
            } else if (exprs.length > 0) {
                anchor = exprs[exprs.length - 1];
            }
            if (anchor != null) {
                argList.addAfter((PsiElement)expression2, anchor);
            } else if (first && exprs.length > 0) {
                argList.addBefore((PsiElement)expression2, (PsiElement)exprs[0]);
            } else {
                argList.add((PsiElement)expression2);
            }
            this.removeParametersFromCall(argList);
        } else {
            LOG.error((Object)element.getParent());
        }
    }

    private void removeParametersFromCall(PsiExpressionList argList) {
        PsiExpression[] exprs = argList.getExpressions();
        this.myParametersToRemove.forEachDescending(paramNum -> {
            if (paramNum < exprs.length) {
                try {
                    exprs[paramNum].delete();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return true;
        });
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"introduce.parameter.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myMethodToReplaceIn)});
        if (string == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static PsiParameter getAnchorParameter(PsiMethod methodToReplaceIn) {
        PsiParameter anchorParameter;
        PsiParameterList parameterList = methodToReplaceIn.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        int length = parameters2.length;
        if (!methodToReplaceIn.isVarArgs()) {
            anchorParameter = length > 0 ? parameters2[length - 1] : null;
        } else {
            LOG.assertTrue(length > 0);
            LOG.assertTrue(parameters2[length - 1].isVarArgs());
            anchorParameter = length > 1 ? parameters2[length - 2] : null;
        }
        return anchorParameter;
    }

    @Override
    public PsiMethod getMethodToReplaceIn() {
        return this.myMethodToReplaceIn;
    }

    @Override
    @NotNull
    public PsiMethod getMethodToSearchFor() {
        PsiMethod psiMethod = this.myMethodToSearchFor;
        if (psiMethod == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(10);
        }
        return psiMethod;
    }

    @Override
    public JavaExpressionWrapper getParameterInitializer() {
        return this.myInitializerWrapper;
    }

    @Override
    @NotNull
    public String getParameterName() {
        String string = this.myParameterName;
        if (string == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public boolean isDeclareFinal() {
        return this.myDeclareFinal;
    }

    @Override
    public boolean isGenerateDelegate() {
        return this.myGenerateDelegate;
    }

    @Override
    @NotNull
    public TIntArrayList getParametersToRemove() {
        TIntArrayList tIntArrayList = this.myParametersToRemove;
        if (tIntArrayList == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(12);
        }
        return tIntArrayList;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            IntroduceParameterProcessor.$$$reportNull$$$0(13);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodToSearchFor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToRemove";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getForcedType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodToSearchFor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersToRemove";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class AnySameNameVariables
    extends JavaRecursiveElementWalkingVisitor {
        private Pair<PsiElement, String> conflict;

        public Pair<PsiElement, String> getConflict() {
            return this.conflict;
        }

        public void visitVariable(PsiVariable variable) {
            if (variable == IntroduceParameterProcessor.this.myLocalVariable) {
                return;
            }
            if (variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() == IntroduceParameterProcessor.this.myMethodToReplaceIn && IntroduceParameterProcessor.this.getParametersToRemove().contains(IntroduceParameterProcessor.this.myMethodToReplaceIn.getParameterList().getParameterIndex((PsiParameter)variable))) {
                return;
            }
            if (IntroduceParameterProcessor.this.myParameterName.equals(variable.getName())) {
                String descr = JavaRefactoringBundle.message((String)"there.is.already.a.0.it.will.conflict.with.an.introduced.parameter", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)variable, (boolean)true)});
                this.conflict = Pair.create((Object)variable, (Object)CommonRefactoringUtil.capitalize((String)descr));
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                AnySameNameVariables.$$$reportNull$$$0(0);
            }
            if (this.conflict != null) {
                return;
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/introduceParameter/IntroduceParameterProcessor$AnySameNameVariables", "visitElement"));
        }
    }

    public static class AnySupers
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myResult;

        public void visitSuperExpression(PsiSuperExpression expression2) {
            this.myResult = true;
        }

        public boolean isResult() {
            return this.myResult;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitElement((PsiElement)expression2);
        }
    }

    private static class ReferencedElementsCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiElement> myResult = new HashSet<PsiElement>();

        private ReferencedElementsCollector() {
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement element = reference.resolve();
            if (element != null) {
                this.myResult.add(element);
            }
        }
    }
}

