/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceparameterobject.IntroduceParameterObjectDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class IntroduceParameterObjectHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiMethod selectedMethod;
        if (editor == null) {
            IntroduceParameterObjectHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            IntroduceParameterObjectHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            IntroduceParameterObjectHandler.$$$reportNull$$$0(2);
        }
        if ((selectedMethod = IntroduceParameterObjectHandler.getSelectedMethod(editor, file, dataContext)) != null) {
            PsiMethod[] deepestSuperMethods = selectedMethod.findDeepestSuperMethods();
            return deepestSuperMethods.length > 0 || IntroduceParameterObjectHandler.getErrorMessage(selectedMethod) == null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceParameterObjectHandler.$$$reportNull$$$0(3);
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiMethod selectedMethod = IntroduceParameterObjectHandler.getSelectedMethod(editor, file, dataContext);
        if (selectedMethod == null) {
            String message2 = RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("the.caret.should.be.positioned.at.the.name.of.the.method.to.be.refactored", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)IntroduceParameterObjectHandler.getRefactoringName(), (String)"refactorj.introduceParameterObject");
            return;
        }
        IntroduceParameterObjectHandler.invoke(project, selectedMethod, editor);
    }

    private static PsiMethod getSelectedMethod(Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiMethod selectedMethod = null;
        if (element instanceof PsiMethod) {
            selectedMethod = (PsiMethod)element;
        } else if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
            selectedMethod = (PsiMethod)((PsiParameter)element).getDeclarationScope();
        } else {
            CaretModel caretModel = editor.getCaretModel();
            int position = caretModel.getOffset();
            PsiElement elementAt = file.findElementAt(position);
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiMethodCallExpression.class);
            if (methodCallExpression != null) {
                selectedMethod = methodCallExpression.resolveMethod();
            } else {
                PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiParameterList.class);
                if (parameterList != null && parameterList.getParent() instanceof PsiMethod) {
                    selectedMethod = (PsiMethod)parameterList.getParent();
                }
            }
        }
        return selectedMethod;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            IntroduceParameterObjectHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            IntroduceParameterObjectHandler.$$$reportNull$$$0(5);
        }
        if (elements.length != 1) {
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)elements[0], PsiMethod.class, (boolean)false);
        if (method == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        IntroduceParameterObjectHandler.invoke(project, method, editor);
    }

    private static void invoke(Project project, PsiMethod selectedMethod, Editor editor) {
        PsiMethod newMethod = SuperMethodWarningUtil.checkSuperMethod(selectedMethod, RefactoringBundle.message((String)"to.refactor"));
        if (newMethod == null) {
            return;
        }
        String message2 = IntroduceParameterObjectHandler.getErrorMessage(newMethod);
        if (message2 != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)IntroduceParameterObjectHandler.getRefactoringName(), (String)"refactorj.introduceParameterObject");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)newMethod)) {
            return;
        }
        new IntroduceParameterObjectDialog(newMethod).show();
    }

    private static String getErrorMessage(PsiMethod newMethod) {
        PsiParameter[] parameters2 = newMethod.getParameterList().getParameters();
        if (parameters2.length == 0) {
            return RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("method.selected.has.no.parameters", new Object[0]);
        }
        if (newMethod instanceof PsiCompiledElement) {
            return RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("the.selected.method.cannot.be.wrapped.because.it.is.defined.in.a.non.project.class", new Object[0]);
        }
        return null;
    }

    private static String getRefactoringName() {
        return RefactorJBundle.message("introduce.parameter.object", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

