/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.migration.EditMigrationEntryDialog;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class EditMigrationDialog
extends DialogWrapper {
    private JBTable myTable;
    private JTextField myNameField;
    private JTextArea myDescriptionTextArea;
    private final Project myProject;
    private final MigrationMap myMigrationMap;

    public EditMigrationDialog(Project project, MigrationMap migrationMap) {
        super(project, true);
        this.myProject = project;
        this.myMigrationMap = migrationMap;
        this.setHorizontalStretch(1.2f);
        this.setTitle(JavaRefactoringBundle.message((String)"edit.migration.map.title", (Object[])new Object[0]));
        this.init();
        this.validateOKButton();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private void validateOKButton() {
        boolean isEnabled = true;
        if (this.myNameField.getText().trim().length() == 0) {
            isEnabled = false;
        } else if (this.myMigrationMap.getEntryCount() == 0) {
            isEnabled = false;
        }
        this.setOKActionEnabled(isEnabled);
    }

    public String getName() {
        return this.myNameField.getText();
    }

    public String getDescription() {
        return this.myDescriptionTextArea.getText();
    }

    protected JComponent createNorthPanel() {
        this.myNameField = new JTextField(this.myMigrationMap.getName());
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditMigrationDialog.this.validateOKButton();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/migration/EditMigrationDialog$1", "textChanged"));
            }
        });
        this.myDescriptionTextArea = new JTextArea(this.myMigrationMap.getDescription(), 3, 40){

            @Override
            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        this.myDescriptionTextArea.setLineWrap(true);
        this.myDescriptionTextArea.setWrapStyleWord(true);
        this.myDescriptionTextArea.setFont(this.myNameField.getFont());
        this.myDescriptionTextArea.setBackground(this.myNameField.getBackground());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myDescriptionTextArea);
        scrollPane.setBorder(this.myNameField.getBorder());
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)new JLabel(JavaRefactoringBundle.message((String)"migration.map.name.prompt", (Object[])new Object[0])), (JComponent)this.myNameField).addLabeledComponent((JComponent)new JLabel(JavaRefactoringBundle.message((String)"migration.map.description.label", (Object[])new Object[0])), (JComponent)scrollPane).addVerticalGap(12).getPanel();
    }

    protected JComponent createCenterPanel() {
        return ToolbarDecorator.createDecorator((JTable)this.createTable()).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditMigrationDialog.this.addRow();
                EditMigrationDialog.this.validateOKButton();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditMigrationDialog.this.removeRow();
                EditMigrationDialog.this.validateOKButton();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditMigrationDialog.this.edit();
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditMigrationDialog.this.moveUp();
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditMigrationDialog.this.moveDown();
            }
        }).createPanel();
    }

    private void edit() {
        EditMigrationEntryDialog dialog = new EditMigrationEntryDialog(this.myProject);
        int selected = this.myTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        dialog.setEntry(entry);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.updateEntry(entry);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected, selected);
    }

    private void addRow() {
        EditMigrationEntryDialog dialog = new EditMigrationEntryDialog(this.myProject);
        MigrationMapEntry entry = new MigrationMapEntry();
        dialog.setEntry(entry);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.updateEntry(entry);
        this.myMigrationMap.addEntry(entry);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsInserted(this.myMigrationMap.getEntryCount() - 1, this.myMigrationMap.getEntryCount() - 1);
        this.myTable.setRowSelectionInterval(this.myMigrationMap.getEntryCount() - 1, this.myMigrationMap.getEntryCount() - 1);
    }

    private void removeRow() {
        int selected = this.myTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        this.myMigrationMap.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= this.myMigrationMap.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            this.myTable.setRowSelectionInterval(selected, selected);
        }
    }

    private void moveUp() {
        int selected = this.myTable.getSelectedRow();
        if (selected < 1) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        MigrationMapEntry previousEntry = this.myMigrationMap.getEntryAt(selected - 1);
        this.myMigrationMap.setEntryAt(previousEntry, selected);
        this.myMigrationMap.setEntryAt(entry, selected - 1);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected - 1, selected);
        this.myTable.setRowSelectionInterval(selected - 1, selected - 1);
    }

    private void moveDown() {
        int selected = this.myTable.getSelectedRow();
        if (selected >= this.myMigrationMap.getEntryCount() - 1) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        MigrationMapEntry nextEntry = this.myMigrationMap.getEntryAt(selected + 1);
        this.myMigrationMap.setEntryAt(nextEntry, selected);
        this.myMigrationMap.setEntryAt(entry, selected + 1);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected, selected + 1);
        this.myTable.setRowSelectionInterval(selected + 1, selected + 1);
    }

    private JBTable createTable() {
        final String[] names2 = new String[]{JavaRefactoringBundle.message((String)"migration.type.column.header", (Object[])new Object[0]), JavaRefactoringBundle.message((String)"migration.old.name.column.header", (Object[])new Object[0]), JavaRefactoringBundle.message((String)"migration.new.name.column.header", (Object[])new Object[0])};
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                return EditMigrationDialog.this.myMigrationMap.getEntryCount();
            }

            @Override
            public Object getValueAt(int row, int col) {
                String suffix;
                MigrationMapEntry entry = EditMigrationDialog.this.myMigrationMap.getEntryAt(row);
                if (col == 0) {
                    if (entry.getType() == 0 && entry.isRecursive()) {
                        return JavaRefactoringBundle.message((String)"migration.package.with.subpackages", (Object[])new Object[0]);
                    }
                    if (entry.getType() == 0 && !entry.isRecursive()) {
                        return JavaRefactoringBundle.message((String)"migration.package", (Object[])new Object[0]);
                    }
                    return JavaRefactoringBundle.message((String)"migration.class", (Object[])new Object[0]);
                }
                String string = suffix = entry.getType() == 0 ? ".*" : "";
                if (col == 1) {
                    return entry.getOldName() + suffix;
                }
                return entry.getNewName() + suffix;
            }

            @Override
            public String getColumnName(int column) {
                return names2[column];
            }

            public Class getColumnClass(int c) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
            }
        };
        this.myTable = new JBTable((TableModel)dataModel);
        this.myTable.setSelectionMode(0);
        this.myTable.setVisibleRowCount(10);
        return this.myTable;
    }
}

