/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.TypeMigrationViewDescriptor;
import com.intellij.refactoring.typeMigration.ui.FailedConversionsDialog;
import com.intellij.refactoring.typeMigration.ui.MigrationPanel;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TypeMigrationProcessor
extends BaseRefactoringProcessor {
    public static volatile boolean ourSkipFailedConversionInTestMode;
    private static final int MAX_ROOT_IN_PREVIEW_PRESENTATION = 3;
    private PsiElement[] myRoots;
    private final Function<PsiElement, PsiType> myRootTypes;
    private final boolean myAllowDependentRoots;
    private final TypeMigrationRules myRules;
    private TypeMigrationLabeler myLabeler;

    public TypeMigrationProcessor(Project project, PsiElement[] roots, Function<PsiElement, PsiType> rootTypes, TypeMigrationRules rules, boolean allowDependentRoots) {
        super(project);
        this.myRoots = roots;
        this.myRules = rules;
        this.myRootTypes = rootTypes;
        this.myAllowDependentRoots = allowDependentRoots;
    }

    public static void runHighlightingTypeMigration(Project project, Editor editor, TypeMigrationRules rules, PsiElement root, PsiType migrationType) {
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, root, migrationType, false, true);
    }

    public static void runHighlightingTypeMigration(Project project, Editor editor, TypeMigrationRules rules, PsiElement root, PsiType migrationType, boolean optimizeImports, boolean allowDependentRoots) {
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, new PsiElement[]{root}, (Function<PsiElement, PsiType>)Functions.constant((Object)migrationType), optimizeImports, allowDependentRoots);
    }

    public static void runHighlightingTypeMigration(final Project project, final Editor editor, TypeMigrationRules rules, PsiElement[] roots, Function<PsiElement, PsiType> migrationTypeFunction, final boolean optimizeImports, boolean allowDependentRoots) {
        final Set containingFiles = ContainerUtil.map2Set((Object[])roots, PsiElement::getContainingFile);
        TypeMigrationProcessor processor = new TypeMigrationProcessor(project, roots, migrationTypeFunction, rules, allowDependentRoots){

            @Override
            public void performRefactoring(UsageInfo @NotNull [] usages) {
                if (usages == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.performRefactoring(usages);
                if (editor != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ArrayList<Object> result = new ArrayList<Object>();
                        for (UsageInfo usage : usages) {
                            PsiElement element = usage.getElement();
                            if (element == null || !containingFiles.contains(element.getContainingFile())) continue;
                            if (element instanceof PsiMethod) {
                                result.add(((PsiMethod)element).getReturnTypeElement());
                                continue;
                            }
                            if (element instanceof PsiVariable) {
                                result.add(((PsiVariable)element).getTypeElement());
                                continue;
                            }
                            result.add(element);
                        }
                        RefactoringUtil.highlightAllOccurrences(project, PsiUtilCore.toPsiElementArray(result), editor);
                    });
                }
                if (optimizeImports) {
                    JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
                    THashSet affectedFiles = new THashSet();
                    for (UsageInfo usage : usages) {
                        PsiFile usageFile = usage.getFile();
                        if (usageFile == null) continue;
                        affectedFiles.add(usageFile);
                    }
                    for (PsiFile file : affectedFiles) {
                        javaCodeStyleManager.optimizeImports(file);
                        javaCodeStyleManager.shortenClassReferences((PsiElement)file);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/typeMigration/TypeMigrationProcessor$1", "performRefactoring"));
            }
        };
        processor.run();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(0);
        }
        return new TypeMigrationViewDescriptor(this.myRoots[0]);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(1);
        }
        if (this.hasFailedConversions()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if (ourSkipFailedConversionInTestMode) {
                    this.prepareSuccessful();
                    return true;
                }
                throw new BaseRefactoringProcessor.ConflictsInTestsException(Arrays.asList(this.myLabeler.getFailedConversionsReport()));
            }
            FailedConversionsDialog dialog = new FailedConversionsDialog(this.myLabeler.getFailedConversionsReport(), this.myProject);
            if (!dialog.showAndGet()) {
                int exitCode = dialog.getExitCode();
                this.prepareSuccessful();
                if (exitCode == 2) {
                    this.previewRefactoring((UsageInfo[])refUsages.get());
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    public boolean hasFailedConversions() {
        return this.myLabeler.hasFailedConversions();
    }

    protected void previewRefactoring(UsageInfo @NotNull [] usages) {
        String name2;
        if (usages == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(2);
        }
        MigrationPanel panel2 = new MigrationPanel(this.myRoots, this.myLabeler, this.myProject, this.isPreviewUsages());
        if (this.myRoots.length == 1) {
            String fromType = Objects.requireNonNull(TypeMigrationLabeler.getElementType(this.myRoots[0])).getPresentableText();
            String toType = ((PsiType)this.myRootTypes.fun((Object)this.myRoots[0])).getPresentableText();
            String text2 = TypeMigrationProcessor.getPresentation(this.myRoots[0]);
            name2 = "Migrate Type of " + text2 + " from '" + fromType + "' to '" + toType + "'";
        } else {
            int rootsInPresentationCount = this.myRoots.length > 3 ? 3 : this.myRoots.length;
            String[] rootsPresentation = new String[rootsInPresentationCount];
            for (int i = 0; i < rootsInPresentationCount; ++i) {
                PsiElement root = this.myRoots[i];
                rootsPresentation[i] = root instanceof PsiNamedElement ? ((PsiNamedElement)root).getName() : root.getText();
            }
            rootsPresentation = StringUtil.surround((String[])rootsPresentation, (String)"'", (String)"'");
            name2 = "Migrate Type of " + StringUtil.join((String[])rootsPresentation, (String)", ");
            if (this.myRoots.length > 3) {
                name2 = name2 + "...";
            }
        }
        Content content = UsageViewContentManager.getInstance((Project)this.myProject).addContent(name2, false, (JComponent)panel2, true, true);
        panel2.setContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Find").activate(null);
    }

    public static String getPresentation(PsiElement element) {
        String text2 = element instanceof PsiField ? "field '" + ((PsiField)element).getName() + "'" : (element instanceof PsiParameter ? "parameter '" + ((PsiParameter)element).getName() + "'" : (element instanceof PsiLocalVariable ? "variable '" + ((PsiLocalVariable)element).getName() + "'" : (element instanceof PsiMethod ? "method '" + ((PsiMethod)element).getName() + "' return" : element.getText())));
        return text2;
    }

    public UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray;
        this.myLabeler = new TypeMigrationLabeler(this.myRules, this.myRootTypes, this.myAllowDependentRoots ? null : this.myRoots, this.myProject);
        try {
            usageInfoArray = this.myLabeler.getMigratedUsages(!this.isPreviewUsages(), this.myRoots);
        }
        catch (TypeMigrationLabeler.MigrateException e) {
            this.setPreviewUsages(true);
            this.myLabeler.clearStopException();
            UsageInfo[] usageInfoArray2 = this.myLabeler.getMigratedUsages(false, this.myRoots);
            if (usageInfoArray2 == null) {
                TypeMigrationProcessor.$$$reportNull$$$0(4);
            }
            return usageInfoArray2;
        }
        if (usageInfoArray == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(5);
        }
        this.myRoots = elements;
    }

    public void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(6);
        }
        TypeMigrationProcessor.change(usages, this.myLabeler, this.myProject);
    }

    public static void change(UsageInfo[] usages, TypeMigrationLabeler labeler, Project project) {
        SmartList newExpressionsToCheckDiamonds = new SmartList();
        TypeMigrationLabeler.MigrationProducer producer = labeler.createMigratorFor(usages);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        ArrayList<UsageInfo> nonCodeUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (((TypeMigrationUsageInfo)usage).isExcluded()) continue;
            PsiElement element = usage.getElement();
            if (element instanceof PsiVariable || element instanceof PsiMember || element instanceof PsiExpression || element instanceof PsiReferenceParameterList) {
                producer.change((TypeMigrationUsageInfo)usage, (Consumer<? super PsiNewExpression>)((Consumer)arg_0 -> TypeMigrationProcessor.lambda$change$0((List)newExpressionsToCheckDiamonds, smartPointerManager, arg_0)));
                continue;
            }
            nonCodeUsages.add(usage);
        }
        for (SmartPsiElementPointer newExpressionPointer : newExpressionsToCheckDiamonds) {
            PsiNewExpression newExpression = (PsiNewExpression)newExpressionPointer.getElement();
            if (newExpression == null) continue;
            labeler.postProcessNewExpression(newExpression);
        }
        for (UsageInfo usageInfo : nonCodeUsages) {
            Object target;
            PsiReference reference;
            PsiElement element = usageInfo.getElement();
            if (element == null || (reference = element.getReference()) == null || !((target = producer.getConversion(usageInfo)) instanceof PsiMember)) continue;
            try {
                reference.bindToElement((PsiElement)target);
            }
            catch (IncorrectOperationException incorrectOperationException) {}
        }
        producer.flush();
    }

    public TypeMigrationLabeler getLabeler() {
        return this.myLabeler;
    }

    @NotNull
    protected String getCommandName() {
        return "TypeMigration";
    }

    private static /* synthetic */ void lambda$change$0(List newExpressionsToCheckDiamonds, SmartPointerManager smartPointerManager, PsiNewExpression expression2) {
        newExpressionsToCheckDiamonds.add(smartPointerManager.createSmartPsiElementPointer((PsiElement)expression2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeMigrationProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "previewRefactoring";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

