/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringChangeUtil {
    private static final Logger LOG = Logger.getInstance(RefactoringChangeUtil.class);

    public static PsiType getTypeByExpression(PsiExpression expr2) {
        PsiType type2;
        PsiType psiType = type2 = expr2 != null ? expr2.getType() : null;
        if (type2 == null) {
            PsiExpression[] initializers;
            if (expr2 instanceof PsiArrayInitializerExpression && (initializers = ((PsiArrayInitializerExpression)expr2).getInitializers()).length > 0) {
                PsiType initType = RefactoringChangeUtil.getTypeByExpression(initializers[0]);
                if (initType == null) {
                    return null;
                }
                return initType.createArrayType();
            }
            if (expr2 instanceof PsiReferenceExpression && PsiUtil.isOnAssignmentLeftHand((PsiExpression)expr2)) {
                return RefactoringChangeUtil.getTypeByExpression(((PsiAssignmentExpression)expr2.getParent()).getRExpression());
            }
            return null;
        }
        return GenericsUtil.getVariableTypeByExpressionType((PsiType)type2);
    }

    public static PsiReferenceExpression qualifyReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiMember member, @Nullable PsiClass qualifyingClass) throws IncorrectOperationException {
        PsiReferenceExpression expressionFromText;
        if (referenceExpression == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(0);
        }
        if (member == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(1);
        }
        PsiManager manager = referenceExpression.getManager();
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethodCallExpression.class, (boolean)true);
        while (methodCallExpression != null) {
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)methodCallExpression)) {
                return referenceExpression;
            }
            methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiMethodCallExpression.class, (boolean)true);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (qualifyingClass == null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            PsiClass containingClass = member.getContainingClass();
            if (parentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                while (parentClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)containingClass, (boolean)true)) {
                    parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true);
                }
                LOG.assertTrue(parentClass != null);
                expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("A.this." + member.getName(), null);
                PsiThisExpression thisExpression = (PsiThisExpression)expressionFromText.getQualifierExpression();
                assert (thisExpression != null);
                PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
                assert (qualifier != null);
                qualifier.replace((PsiElement)factory.createClassReferenceElement(parentClass));
            } else {
                PsiModifierListOwner staticElement = PsiUtil.getEnclosingStaticElement((PsiElement)referenceExpression, null);
                if (staticElement != null && containingClass != null && !PsiTreeUtil.isAncestor((PsiElement)staticElement, (PsiElement)containingClass, (boolean)false)) {
                    return referenceExpression;
                }
                expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("this." + member.getName(), null);
            }
        } else {
            expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("A." + member.getName(), null);
            expressionFromText.setQualifierExpression((PsiExpression)factory.createReferenceExpression(qualifyingClass));
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        expressionFromText = (PsiReferenceExpression)codeStyleManager.reformat((PsiElement)expressionFromText);
        return (PsiReferenceExpression)referenceExpression.replace((PsiElement)expressionFromText);
    }

    public static PsiClass getThisClass(@NotNull PsiElement place) {
        PsiElement parent;
        if (place == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(2);
        }
        if ((parent = place.getContext()) == null) {
            return null;
        }
        PsiElement prev = null;
        do {
            if (parent instanceof PsiClass && (!(parent instanceof PsiAnonymousClass) || ((PsiAnonymousClass)parent).getArgumentList() != prev)) {
                return (PsiClass)parent;
            }
            prev = parent;
        } while ((parent = parent.getContext()) != null);
        return null;
    }

    @Nullable
    public static PsiClass getQualifierClass(@NotNull PsiReferenceExpression expression2) {
        PsiExpression qualifierExpression2;
        if (expression2 == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(3);
        }
        if ((qualifierExpression2 = expression2.getQualifierExpression()) != null) {
            PsiClass aClass;
            PsiType expressionType = qualifierExpression2.getType();
            if (expressionType instanceof PsiCapturedWildcardType) {
                expressionType = ((PsiCapturedWildcardType)expressionType).getUpperBound();
            }
            if ((aClass = PsiUtil.resolveClassInType((PsiType)expressionType)) != null) {
                return aClass;
            }
            if (qualifierExpression2 instanceof PsiReferenceExpression) {
                PsiElement qResolved = ((PsiReferenceExpression)qualifierExpression2).resolve();
                return qResolved instanceof PsiClass ? (PsiClass)qResolved : null;
            }
            return null;
        }
        return RefactoringChangeUtil.getThisClass((PsiElement)expression2);
    }

    static <T extends PsiQualifiedExpression> T createQualifiedExpression(@NotNull PsiManager manager, PsiClass qualifierClass, @NotNull String qName) throws IncorrectOperationException {
        if (manager == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(4);
        }
        if (qName == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(5);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        if (qualifierClass != null) {
            PsiQualifiedExpression qualifiedThis = (PsiQualifiedExpression)factory.createExpressionFromText("q." + qName, (PsiElement)qualifierClass);
            qualifiedThis = (PsiQualifiedExpression)CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)qualifiedThis);
            PsiJavaCodeReferenceElement thisQualifier = qualifiedThis.getQualifier();
            LOG.assertTrue(thisQualifier != null);
            thisQualifier.bindToElement((PsiElement)qualifierClass);
            return (T)qualifiedThis;
        }
        return (T)((PsiQualifiedExpression)factory.createExpressionFromText(qName, null));
    }

    public static PsiThisExpression createThisExpression(PsiManager manager, PsiClass qualifierClass) throws IncorrectOperationException {
        return (PsiThisExpression)RefactoringChangeUtil.createQualifiedExpression(manager, qualifierClass, "this");
    }

    public static PsiSuperExpression createSuperExpression(PsiManager manager, PsiClass qualifierClass) throws IncorrectOperationException {
        return (PsiSuperExpression)RefactoringChangeUtil.createQualifiedExpression(manager, qualifierClass, "super");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/RefactoringChangeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifyReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getThisClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifierClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createQualifiedExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

