/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi;

import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static final SPIFileType INSTANCE = new SPIFileType();

    private SPIFileType() {
        super((Language)SPILanguage.INSTANCE);
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        VirtualFile gParent;
        VirtualFile parent;
        if (file == null) {
            SPIFileType.$$$reportNull$$$0(0);
        }
        if ((parent = file.getParent()) != null && Comparing.equal((CharSequence)"services", (CharSequence)parent.getNameSequence()) && (gParent = parent.getParent()) != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)gParent.getNameSequence())) {
            String fileName = file.getName();
            for (Object condition2 : Extensions.getRootArea().getExtensionPoint("com.intellij.vetoSPICondition").getExtensions()) {
                if (!((Condition)condition2).value((Object)fileName)) continue;
                return false;
            }
            return FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) == FileTypes.UNKNOWN;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return "SPI";
    }

    @NotNull
    public String getDescription() {
        String string = JavaBundle.message((String)"spi.file.type.description", (Object[])new Object[0]);
        if (string == null) {
            SPIFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    @Nullable
    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            SPIFileType.$$$reportNull$$$0(2);
        }
        if (content == null) {
            SPIFileType.$$$reportNull$$$0(3);
        }
        return "UTF-8";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spi/SPIFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spi/SPIFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMyFileType";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

