/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;

public class TestLocator {
    private final Project myProject;

    public TestLocator(Project project) {
        this.myProject = project;
    }

    public Location getLocation(String url) {
        return TestLocator.getLocation(url, this.myProject);
    }

    public static Location getLocation(String url, Project project) {
        List<Location> locations;
        String protocol = VirtualFileManager.extractProtocol((String)url);
        String path = VirtualFileManager.extractPath((String)url);
        if (protocol != null && !(locations = JavaTestLocator.INSTANCE.getLocation(protocol, path, project, GlobalSearchScope.allScope((Project)project))).isEmpty()) {
            return locations.get(0);
        }
        return null;
    }

    public static boolean canLocate(String url) {
        return TestLocator.isSuite(url) || TestLocator.isTest(url);
    }

    public static boolean isSuite(String url) {
        String protocol = VirtualFileManager.extractProtocol((String)url);
        return "java:suite".equals(protocol);
    }

    public static boolean isTest(String url) {
        String protocol = VirtualFileManager.extractProtocol((String)url);
        return "java:test".equals(protocol);
    }
}

