/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.LibraryUtil;
import org.jetbrains.annotations.Nullable;

class ConcreteClassUtil {
    private ConcreteClassUtil() {
    }

    public static boolean typeIsConcreteClass(@Nullable PsiTypeElement typeElement, boolean ignoreCastToAbstractClass) {
        if (typeElement == null) {
            return false;
        }
        PsiType type2 = typeElement.getType();
        return ConcreteClassUtil.typeIsConcreteClass(type2, ignoreCastToAbstractClass);
    }

    public static boolean typeIsConcreteClass(@Nullable PsiType type2, boolean ignoreCastToAbstractClass) {
        if (type2 == null) {
            return false;
        }
        PsiType baseType = type2.getDeepComponentType();
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
        if (aClass == null) {
            return false;
        }
        if (ignoreCastToAbstractClass && aClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter) {
            return false;
        }
        return !LibraryUtil.classIsInLibrary(aClass);
    }
}

