/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceConstantFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MagicNumberInspection
extends BaseInspection {
    public boolean ignoreInHashCode = true;
    public boolean ignoreInTestCode = false;
    public boolean ignoreInAnnotations = true;
    public boolean ignoreInitialCapacity = false;

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        SuppressForTestsScopeFix fix2 = SuppressForTestsScopeFix.build(this, context);
        if (fix2 == null) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new IntroduceConstantFix()};
            if (inspectionGadgetsFixArray == null) {
                MagicNumberInspection.$$$reportNull$$$0(0);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new IntroduceConstantFix(), fix2};
        if (inspectionGadgetsFixArray == null) {
            MagicNumberInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("magic.number.problem.descriptor", new Object[0]);
        if (string == null) {
            MagicNumberInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.in.hashcode", new Object[0]), "ignoreInHashCode");
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.in.annotations", new Object[0]), "ignoreInAnnotations");
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.option.ignore.as.initial.capacity", new Object[0]), "ignoreInitialCapacity");
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MagicNumberVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/MagicNumberInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MagicNumberVisitor
    extends BaseInspectionVisitor {
        private MagicNumberVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            boolean insideAnnotation;
            PsiMethod containingMethod;
            if (expression2 == null) {
                MagicNumberVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!ClassUtils.isPrimitiveNumericType(type2) || PsiType.CHAR.equals((Object)type2)) {
                return;
            }
            if (this.isSpecialCaseLiteral(expression2) || this.isFinalVariableInitialization((PsiExpression)expression2)) {
                return;
            }
            if (MagicNumberInspection.this.ignoreInHashCode && MethodUtils.isHashCode(containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            if (MagicNumberInspection.this.ignoreInAnnotations && (insideAnnotation = AnnotationUtil.isInsideAnnotation((PsiElement)expression2))) {
                return;
            }
            if (MagicNumberInspection.this.ignoreInitialCapacity && this.isInitialCapacity(expression2)) {
                return;
            }
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class, (boolean)true, (Class[])new Class[]{PsiCallExpression.class});
            if (field != null && PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiPrefixExpression) {
                this.registerError(parent, parent);
            } else {
                this.registerError((PsiElement)expression2, expression2);
            }
        }

        private boolean isInitialCapacity(PsiLiteralExpression expression2) {
            PsiElement element = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{PsiTypeCastExpression.class, PsiParenthesizedExpression.class});
            if (!(element instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                return false;
            }
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            return TypeUtils.expressionHasTypeOrSubtype((PsiExpression)newExpression, "java.lang.AbstractStringBuilder", "java.util.Map", "java.util.Collection", "java.io.ByteArrayOutputStream", "java.awt.Dimension") != null;
        }

        private boolean isSpecialCaseLiteral(PsiLiteralExpression expression2) {
            Object object = ExpressionUtils.computeConstantExpression((PsiExpression)expression2);
            if (object instanceof Integer) {
                int i = (Integer)object;
                return i >= 0 && i <= 10 || i == 100 || i == 1000;
            }
            if (object instanceof Long) {
                long l = (Long)object;
                return l >= 0L && l <= 2L;
            }
            if (object instanceof Double) {
                double d = (Double)object;
                return d == 1.0 || d == 0.0;
            }
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                return f == 1.0f || f == 0.0f;
            }
            return false;
        }

        public boolean isFinalVariableInitialization(PsiExpression expression2) {
            PsiVariable variable;
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiVariable.class, PsiAssignmentExpression.class});
            if (!(parent instanceof PsiVariable)) {
                if (!(parent instanceof PsiAssignmentExpression)) {
                    return false;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return false;
                }
                variable = (PsiVariable)target;
            } else {
                variable = (PsiVariable)parent;
            }
            return variable.hasModifierProperty("final");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/abstraction/MagicNumberInspection$MagicNumberVisitor", "visitLiteralExpression"));
        }
    }
}

