/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PublicMethodNotExposedInInterfaceInspection
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean onlyWarnIfContainingClassImplementsAnInterface = false;

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        constraints.fill = 1;
        panel2.add((Component)annotationsListControl, constraints);
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("public.method.not.in.interface.option", new Object[0]), (InspectionProfileEntry)this, "onlyWarnIfContainingClassImplementsAnInterface");
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        panel2.add((Component)checkBox, constraints);
        return panel2;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.method.not.in.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            PublicMethodNotExposedInInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)infos[0], (List<String>)((Object)this.ignorableAnnotations));
        if (inspectionGadgetsFixArray == null) {
            PublicMethodNotExposedInInterfaceInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodNotExposedInInterfaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PublicMethodNotExposedInInterfaceVisitor
    extends BaseInspectionVisitor {
        private PublicMethodNotExposedInInterfaceVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                PublicMethodNotExposedInInterfaceVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!containingClass.hasModifierProperty("public")) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (Collection)((Object)PublicMethodNotExposedInInterfaceInspection.this.ignorableAnnotations), (int)0)) {
                return;
            }
            if (PublicMethodNotExposedInInterfaceInspection.this.onlyWarnIfContainingClassImplementsAnInterface) {
                PsiClass[] superClasses = containingClass.getSupers();
                boolean implementsInterface = false;
                for (PsiClass superClass : superClasses) {
                    if (!superClass.isInterface() || LibraryUtil.classIsInLibrary(superClass)) continue;
                    implementsInterface = true;
                    break;
                }
                if (!implementsInterface) {
                    return;
                }
            }
            if (this.exposedInInterface(method, new HashSet<PsiMethod>())) {
                return;
            }
            if (TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }

        private boolean exposedInInterface(PsiMethod method, Set<PsiMethod> seen) {
            if (!seen.add(method)) {
                return true;
            }
            Object[] superMethods = method.findSuperMethods();
            PsiMethod siblingInherited = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method);
            if (siblingInherited != null && !ArrayUtil.contains((Object)siblingInherited, (Object[])superMethods)) {
                superMethods = (PsiMethod[])ArrayUtil.append((Object[])superMethods, (Object)siblingInherited);
            }
            for (Object superMethod : superMethods) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null) continue;
                if (superClass.isInterface()) {
                    return true;
                }
                String superclassName = superClass.getQualifiedName();
                if ("java.lang.Object".equals(superclassName)) {
                    return true;
                }
                if (!this.exposedInInterface((PsiMethod)superMethod, seen)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/abstraction/PublicMethodNotExposedInInterfaceInspection$PublicMethodNotExposedInInterfaceVisitor", "visitMethod"));
        }
    }
}

