/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.BaseSharedLocalInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;

public class StaticMethodOnlyUsedInOneClassInspection
extends BaseGlobalInspection {
    public boolean ignoreTestClasses = false;
    public boolean ignoreAnonymousClasses = true;
    public boolean ignoreOnConflicts = true;
    public boolean ignoreUtilityClasses = true;
    static final Key<SmartPsiElementPointer<PsiClass>> MARKER = Key.create((String)"STATIC_METHOD_USED_IN_ONE_CLASS");

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.test.option", new Object[0]), "ignoreTestClasses");
        panel2.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.anonymous.option", new Object[0]), "ignoreAnonymousClasses");
        panel2.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.on.conflicts", new Object[0]), "ignoreOnConflicts");
        panel2.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.utility.classes", new Object[0]), "ignoreUtilityClasses");
        return panel2;
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        RefClass containingClass;
        if (refEntity == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(3);
        }
        if (!(refEntity instanceof RefMethod) && !(refEntity instanceof RefField)) {
            return null;
        }
        RefJavaElement element = (RefJavaElement)refEntity;
        if (!element.isStatic() || element.getAccessModifier() == "private") {
            return null;
        }
        RefClass usageClass = null;
        for (RefElement reference : element.getInReferences()) {
            RefClass ownerClass = StaticMethodOnlyUsedInOneClassInspection.getOwnerClass((RefEntity)reference);
            if (usageClass == null) {
                usageClass = ownerClass;
                continue;
            }
            if (usageClass == ownerClass) continue;
            return null;
        }
        RefClass refClass = containingClass = element instanceof RefMethod ? ((RefMethod)element).getOwnerClass() : ((RefField)element).getOwnerClass();
        if (containingClass == null || usageClass == containingClass) {
            return null;
        }
        if (usageClass == null) {
            PsiClass aClass = (PsiClass)ObjectUtils.tryCast((Object)containingClass.getPsiElement(), PsiClass.class);
            if (aClass != null) {
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)manager.getProject());
                element.putUserData(MARKER, (Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)aClass));
            }
            return null;
        }
        if (this.ignoreAnonymousClasses && (usageClass.isAnonymous() || usageClass.isLocalClass() || usageClass.getOwner() instanceof RefClass && !usageClass.isStatic())) {
            return null;
        }
        if (this.ignoreTestClasses && usageClass.isTestCase()) {
            return null;
        }
        if (this.ignoreUtilityClasses && containingClass.isUtilityClass()) {
            return null;
        }
        PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)usageClass.getPsiElement(), PsiClass.class);
        if (psiClass == null) {
            return null;
        }
        if (element instanceof RefMethod) {
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)element.getPsiElement(), PsiMethod.class);
            if (method == null || MethodUtils.isFactoryMethod(method) || MethodUtils.isConvenienceOverload(method)) {
                return null;
            }
            if (this.ignoreOnConflicts && (psiClass.findMethodsBySignature(method, true).length > 0 || !StaticMethodOnlyUsedInOneClassInspection.areReferenceTargetsAccessible((PsiElement)method, (PsiElement)psiClass))) {
                return null;
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)manager.getProject());
            element.putUserData(MARKER, (Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)psiClass));
            return new ProblemDescriptor[]{StaticMethodOnlyUsedInOneClassInspection.createProblemDescriptor(manager, (PsiElement)method.getNameIdentifier(), psiClass)};
        }
        PsiField field = (PsiField)ObjectUtils.tryCast((Object)element.getPsiElement(), PsiField.class);
        if (field == null || field instanceof PsiEnumConstant || StaticMethodOnlyUsedInOneClassInspection.isSingletonField(field)) {
            return null;
        }
        if (this.ignoreOnConflicts && (psiClass.findFieldByName(element.getName(), true) != null || !StaticMethodOnlyUsedInOneClassInspection.areReferenceTargetsAccessible((PsiElement)field, (PsiElement)psiClass))) {
            return null;
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)manager.getProject());
        element.putUserData(MARKER, (Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)psiClass));
        return new ProblemDescriptor[]{StaticMethodOnlyUsedInOneClassInspection.createProblemDescriptor(manager, (PsiElement)field.getNameIdentifier(), psiClass)};
    }

    @Nullable
    private static RefClass getOwnerClass(RefEntity element) {
        while (!(element instanceof RefClass) && element instanceof RefJavaElement) {
            element = element.getOwner();
        }
        return element instanceof RefClass ? (RefClass)element : null;
    }

    @NotNull
    static ProblemDescriptor createProblemDescriptor(@NotNull InspectionManager manager, PsiElement problemElement, PsiClass usageClass) {
        if (manager == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(4);
        }
        String message2 = usageClass instanceof PsiAnonymousClass ? InspectionGadgetsBundle.message("static.method.only.used.in.one.anonymous.class.problem.descriptor", problemElement.getParent() instanceof PsiMethod ? 1 : 2, ((PsiAnonymousClass)usageClass).getBaseClassReference().getText()) : InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor", problemElement.getParent() instanceof PsiMethod ? 1 : 2, usageClass.getName());
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(problemElement, message2, false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        if (problemDescriptor == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(5);
        }
        return problemDescriptor;
    }

    public boolean queryExternalUsagesRequests(final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(6);
        }
        if (globalContext == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(7);
        }
        if (problemDescriptionsProcessor == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(8);
        }
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(final @NotNull RefEntity refEntity) {
                SmartPsiElementPointer classPointer;
                if (refEntity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((classPointer = (SmartPsiElementPointer)refEntity.getUserData(MARKER)) != null) {
                    final Ref ref = Ref.create((Object)classPointer.getElement());
                    GlobalJavaInspectionContext globalJavaContext = (GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT);
                    GlobalJavaInspectionContext.UsagesProcessor processor = new GlobalJavaInspectionContext.UsagesProcessor(){

                        public boolean process(PsiReference reference) {
                            PsiClass containingClass = ClassUtils.getContainingClass(reference.getElement());
                            if (problemDescriptionsProcessor.getDescriptions(refEntity) != null) {
                                if (containingClass != ref.get()) {
                                    problemDescriptionsProcessor.ignoreElement(refEntity);
                                    return false;
                                }
                            } else {
                                UElement anchor;
                                UElement uElement = anchor = refEntity instanceof RefMethod ? ((RefMethod)refEntity).getUastElement().getUastAnchor() : ((RefField)refEntity).getUastElement().getUastAnchor();
                                if (anchor == null) {
                                    return false;
                                }
                                PsiElement identifier = anchor.getSourcePsi();
                                ProblemDescriptor problemDescriptor = StaticMethodOnlyUsedInOneClassInspection.createProblemDescriptor(manager, identifier, containingClass);
                                problemDescriptionsProcessor.addProblemElement(refEntity, new CommonProblemDescriptor[]{problemDescriptor});
                                ref.set((Object)containingClass);
                            }
                            return true;
                        }
                    };
                    if (refEntity instanceof RefMethod) {
                        globalJavaContext.enqueueMethodUsagesProcessor((RefMethod)refEntity, processor);
                    } else if (refEntity instanceof RefField) {
                        globalJavaContext.enqueueFieldUsagesProcessor((RefField)refEntity, processor);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$1", "visitElement"));
            }
        });
        return false;
    }

    static boolean isSingletonField(PsiField field) {
        return field.hasModifierProperty("final") && field.hasModifierProperty("static") && field.getContainingClass() == PsiUtil.resolveClassInClassTypeOnly((PsiType)field.getType());
    }

    static boolean areReferenceTargetsAccessible(PsiElement elementToCheck, PsiElement place) {
        AccessibleVisitor visitor2 = new AccessibleVisitor(elementToCheck, place);
        elementToCheck.accept((PsiElementVisitor)visitor2);
        return visitor2.isAccessible();
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new StaticMethodOnlyUsedInOneClassLocalInspection(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StaticMethodOnlyUsedInOneClassLocalInspection
    extends BaseSharedLocalInspection<StaticMethodOnlyUsedInOneClassInspection> {
        StaticMethodOnlyUsedInOneClassLocalInspection(StaticMethodOnlyUsedInOneClassInspection settingsDelegate) {
            super(settingsDelegate);
        }

        @Override
        @NotNull
        protected String buildErrorString(Object ... infos) {
            PsiMember member = (PsiMember)infos[0];
            PsiClass usageClass = (PsiClass)infos[1];
            String string = usageClass instanceof PsiAnonymousClass ? InspectionGadgetsBundle.message("static.method.only.used.in.one.anonymous.class.problem.descriptor", member instanceof PsiMethod ? 1 : 2, ((PsiAnonymousClass)usageClass).getBaseClassReference().getText()) : InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor", member instanceof PsiMethod ? 1 : 2, usageClass.getName());
            if (string == null) {
                StaticMethodOnlyUsedInOneClassLocalInspection.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected InspectionGadgetsFix buildFix(Object ... infos) {
            PsiMember member = (PsiMember)infos[0];
            PsiClass usageClass = (PsiClass)infos[1];
            return new StaticMethodOnlyUsedInOneClassFix(usageClass, member instanceof PsiMethod);
        }

        @Override
        public BaseInspectionVisitor buildVisitor() {
            return new StaticMethodOnlyUsedInOneClassVisitor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassLocalInspection", "buildErrorString"));
        }

        private class StaticMethodOnlyUsedInOneClassVisitor
        extends BaseInspectionVisitor {
            private StaticMethodOnlyUsedInOneClassVisitor() {
            }

            public void visitField(PsiField field) {
                super.visitField(field);
                if (!field.hasModifierProperty("static") || field.hasModifierProperty("private")) {
                    return;
                }
                if (field instanceof PsiEnumConstant || StaticMethodOnlyUsedInOneClassInspection.isSingletonField(field)) {
                    return;
                }
                if (DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)field, true)) {
                    return;
                }
                PsiClass usageClass = this.getUsageClass((PsiMember)field);
                if (usageClass == null) {
                    return;
                }
                this.registerFieldError(field, field, usageClass);
            }

            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                if (!method.hasModifierProperty("static") || method.hasModifierProperty("private") || method.getNameIdentifier() == null) {
                    return;
                }
                if (MethodUtils.isFactoryMethod(method) || MethodUtils.isConvenienceOverload(method)) {
                    return;
                }
                if (DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)method, true)) {
                    return;
                }
                PsiClass usageClass = this.getUsageClass((PsiMember)method);
                if (usageClass == null) {
                    return;
                }
                this.registerMethodError(method, method, usageClass);
            }

            private PsiClass getUsageClass(PsiMember member) {
                UsageProcessor usageProcessor = new UsageProcessor();
                PsiClass usageClass = usageProcessor.findUsageClass(member);
                if (usageClass == null) {
                    return null;
                }
                PsiClass containingClass = member.getContainingClass();
                if (containingClass == null || usageClass.equals(containingClass)) {
                    return null;
                }
                if (((StaticMethodOnlyUsedInOneClassInspection)((StaticMethodOnlyUsedInOneClassLocalInspection)StaticMethodOnlyUsedInOneClassLocalInspection.this).mySettingsDelegate).ignoreTestClasses && TestUtils.isInTestCode((PsiElement)usageClass)) {
                    return null;
                }
                if ((usageClass.getContainingClass() != null && !usageClass.hasModifierProperty("static") || PsiUtil.isLocalOrAnonymousClass((PsiClass)usageClass)) && (((StaticMethodOnlyUsedInOneClassInspection)((StaticMethodOnlyUsedInOneClassLocalInspection)StaticMethodOnlyUsedInOneClassLocalInspection.this).mySettingsDelegate).ignoreAnonymousClasses || PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)usageClass, (boolean)true))) {
                    return null;
                }
                if (((StaticMethodOnlyUsedInOneClassInspection)((StaticMethodOnlyUsedInOneClassLocalInspection)StaticMethodOnlyUsedInOneClassLocalInspection.this).mySettingsDelegate).ignoreUtilityClasses && UtilityClassUtil.isUtilityClass(containingClass)) {
                    return null;
                }
                if (((StaticMethodOnlyUsedInOneClassInspection)((StaticMethodOnlyUsedInOneClassLocalInspection)StaticMethodOnlyUsedInOneClassLocalInspection.this).mySettingsDelegate).ignoreOnConflicts && (member instanceof PsiMethod ? usageClass.findMethodsBySignature((PsiMethod)member, true).length > 0 || !StaticMethodOnlyUsedInOneClassInspection.areReferenceTargetsAccessible((PsiElement)member, (PsiElement)usageClass) : member instanceof PsiField && (usageClass.findFieldByName(member.getName(), true) != null || !StaticMethodOnlyUsedInOneClassInspection.areReferenceTargetsAccessible((PsiElement)member, (PsiElement)usageClass)))) {
                    return null;
                }
                return usageClass;
            }
        }

        private static class StaticMethodOnlyUsedInOneClassFix
        extends RefactoringInspectionGadgetsFix {
            private final SmartPsiElementPointer<PsiClass> myUsageClass;
            private final boolean myMethod;

            StaticMethodOnlyUsedInOneClassFix(PsiClass usageClass, boolean method) {
                this.myMethod = method;
                SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)usageClass.getProject());
                this.myUsageClass = pointerManager.createSmartPsiElementPointer((PsiElement)usageClass);
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.quickfix", this.myMethod ? 1 : 2);
                if (string == null) {
                    StaticMethodOnlyUsedInOneClassFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public RefactoringActionHandler getHandler() {
                RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
                if (refactoringActionHandler == null) {
                    StaticMethodOnlyUsedInOneClassFix.$$$reportNull$$$0(1);
                }
                return refactoringActionHandler;
            }

            @NotNull
            public DataContext enhanceDataContext(DataContext context) {
                DataContext dataContext = SimpleDataContext.getSimpleContext((String)LangDataKeys.TARGET_PSI_ELEMENT.getName(), (Object)this.myUsageClass.getElement(), (DataContext)context);
                if (dataContext == null) {
                    StaticMethodOnlyUsedInOneClassFix.$$$reportNull$$$0(2);
                }
                return dataContext;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassLocalInspection$StaticMethodOnlyUsedInOneClassFix";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHandler";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "enhanceDataContext";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    private static class UsageProcessor
    implements Processor<PsiReference> {
        private final AtomicReference<PsiClass> foundClass = new AtomicReference();

        private UsageProcessor() {
        }

        public boolean process(PsiReference reference) {
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            PsiClass usageClass = ClassUtils.getContainingClass(element);
            if (usageClass == null) {
                return true;
            }
            if (this.foundClass.compareAndSet(null, usageClass)) {
                return true;
            }
            PsiClass aClass = this.foundClass.get();
            PsiManager manager = usageClass.getManager();
            return manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)usageClass);
        }

        @Nullable
        public PsiClass findUsageClass(PsiMember member) {
            ProgressManager.getInstance().runProcess(() -> {
                Query query;
                Query query2 = query = member instanceof PsiMethod ? MethodReferencesSearch.search((PsiMethod)((PsiMethod)member)) : ReferencesSearch.search((PsiElement)member);
                if (!query.forEach((Processor)this)) {
                    this.foundClass.set(null);
                }
            }, null);
            return this.foundClass.get();
        }
    }

    private static class AccessibleVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiElement myElementToCheck;
        private final PsiElement myPlace;
        private boolean myAccessible = true;

        AccessibleVisitor(PsiElement elementToCheck, PsiElement place) {
            this.myElementToCheck = elementToCheck;
            this.myPlace = place;
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            if (!this.myAccessible) {
                return;
            }
            super.visitCallExpression(callExpression);
            PsiMethod method = callExpression.resolveMethod();
            if (callExpression instanceof PsiNewExpression && method == null) {
                PsiNewExpression newExpression = (PsiNewExpression)callExpression;
                PsiJavaCodeReferenceElement reference = newExpression.getClassReference();
                if (reference != null) {
                    this.checkElement(reference.resolve());
                }
            } else {
                this.checkElement((PsiElement)method);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (!this.myAccessible) {
                return;
            }
            super.visitReferenceExpression(expression2);
            this.checkElement(expression2.resolve());
        }

        private void checkElement(PsiElement element) {
            if (!(element instanceof PsiMember)) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myElementToCheck, (PsiElement)element, (boolean)false)) {
                return;
            }
            this.myAccessible = PsiUtil.isAccessible((PsiMember)((PsiMember)element), (PsiElement)this.myPlace, null);
        }

        public boolean isAccessible() {
            return this.myAccessible;
        }
    }
}

