/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitArrayToStringInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[1]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("explicit.array.to.string.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitArrayToStringInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (infos[0] instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.method.call.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitArrayToStringInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("implicit.array.to.string.problem.descriptor", new Object[0]);
        if (string == null) {
            ImplicitArrayToStringInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiType componentType;
        PsiExpression expression2 = (PsiExpression)infos[0];
        boolean removeToString = (Boolean)infos[1];
        PsiArrayType type2 = (PsiArrayType)expression2.getType();
        if (type2 != null && (componentType = type2.getComponentType()) instanceof PsiArrayType) {
            return new ImplicitArrayToStringFix(true, removeToString);
        }
        return new ImplicitArrayToStringFix(false, removeToString);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitArrayToStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ImplicitArrayToStringInspection", "buildErrorString"));
    }

    private static class ImplicitArrayToStringVisitor
    extends BaseInspectionVisitor {
        private ImplicitArrayToStringVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, Boolean.FALSE);
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, Boolean.FALSE);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            super.visitArrayAccessExpression(expression2);
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, Boolean.FALSE);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (ImplicitArrayToStringVisitor.isExplicitArrayToStringCall(expression2)) {
                PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                this.registerMethodCallError(expression2, qualifier, Boolean.TRUE);
                return;
            }
            if (!ImplicitArrayToStringVisitor.isImplicitArrayToStringCall((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2, Boolean.FALSE);
        }

        private static boolean isExplicitArrayToStringCall(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName) || !expression2.getArgumentList().isEmpty()) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type2 = qualifier.getType();
            return type2 instanceof PsiArrayType;
        }

        private static boolean isImplicitArrayToStringCall(PsiExpression expression2) {
            return ExpressionUtils.isImplicitToStringCall(expression2) && expression2.getType() instanceof PsiArrayType;
        }
    }

    private static class ImplicitArrayToStringFix
    extends InspectionGadgetsFix {
        private final boolean deepString;
        private final boolean removeToString;

        ImplicitArrayToStringFix(boolean deepString, boolean removeToString) {
            this.deepString = deepString;
            this.removeToString = removeToString;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.fix.family.name", new Object[0]);
            if (string == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String expressionText = this.deepString ? "java.util.Arrays.deepToString()" : "java.util.Arrays.toString()";
            String string = InspectionGadgetsBundle.message("implicit.array.to.string.quickfix", expressionText);
            if (string == null) {
                ImplicitArrayToStringFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethodCallExpression methodCallExpression;
            PsiReferenceExpression methodExpression;
            PsiElement grandParent;
            String expressionText;
            PsiElement element = descriptor.getPsiElement();
            PsiExpression expression2 = element instanceof PsiExpression ? (PsiExpression)element : (PsiExpression)element.getParent().getParent();
            CommentTracker commentTracker = new CommentTracker();
            if (this.removeToString) {
                PsiMethodCallExpression methodCallExpression2 = (PsiMethodCallExpression)expression2;
                PsiReferenceExpression methodExpression2 = methodCallExpression2.getMethodExpression();
                PsiExpression qualifier = methodExpression2.getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                expressionText = commentTracker.text((PsiElement)qualifier);
            } else {
                expressionText = commentTracker.text((PsiElement)expression2);
            }
            String newExpressionText = this.deepString ? "java.util.Arrays.deepToString(" + expressionText + ')' : "java.util.Arrays.toString(" + expressionText + ')';
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && "valueOf".equals((methodExpression = (methodCallExpression = (PsiMethodCallExpression)grandParent).getMethodExpression()).getReferenceName())) {
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, newExpressionText, commentTracker);
                return;
            }
            PsiReplacementUtil.replaceExpressionAndShorten(expression2, newExpressionText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/ImplicitArrayToStringInspection$ImplicitArrayToStringFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

