/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousIntegerDivAssignmentInspection
extends BaseInspection {
    public boolean myReportPossiblyExactDivision = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("suspicious.integer.div.assignment.problem.descriptor", new Object[0]);
        if (string == null) {
            SuspiciousIntegerDivAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"inspection.suspicious.integer.div.assignment.option", (Object[])new Object[0]), "myReportPossiblyExactDivision");
        return panel2;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SuspiciousIntegerDivAssignmentFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousIntegerDivAssignmentVisitor();
    }

    @Nullable
    private static PsiBinaryExpression getRhs(@NotNull PsiAssignmentExpression assignment) {
        PsiBinaryExpression rhs;
        if (assignment == null) {
            SuspiciousIntegerDivAssignmentInspection.$$$reportNull$$$0(1);
        }
        if ((rhs = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()), PsiBinaryExpression.class)) == null || !rhs.getOperationTokenType().equals(JavaTokenType.DIV) || !TypeConversionUtil.isIntegralNumberType((PsiType)rhs.getType())) {
            return null;
        }
        return rhs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRhs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SuspiciousIntegerDivAssignmentVisitor
    extends BaseInspectionVisitor {
        private SuspiciousIntegerDivAssignmentVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            LongRangeSet divisorRange;
            if (assignment == null) {
                SuspiciousIntegerDivAssignmentVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(assignment);
            IElementType assignmentTokenType = assignment.getOperationTokenType();
            if (!assignmentTokenType.equals(JavaTokenType.ASTERISKEQ) && !assignmentTokenType.equals(JavaTokenType.DIVEQ)) {
                return;
            }
            PsiBinaryExpression rhs = SuspiciousIntegerDivAssignmentInspection.getRhs(assignment);
            if (rhs == null) {
                return;
            }
            LongRangeSet dividendRange = CommonDataflow.getExpressionRange(rhs.getLOperand());
            if (dividendRange != null && (divisorRange = CommonDataflow.getExpressionRange(rhs.getROperand())) != null) {
                LongRangeSet modRange = dividendRange.mod(divisorRange);
                if (modRange.isEmpty() || LongRangeSet.point(0L).equals(modRange)) {
                    return;
                }
                if (!modRange.contains(0L)) {
                    this.registerError((PsiElement)assignment, new Object[0]);
                    return;
                }
            }
            if (!SuspiciousIntegerDivAssignmentInspection.this.myReportPossiblyExactDivision) {
                return;
            }
            this.registerError((PsiElement)assignment, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection$SuspiciousIntegerDivAssignmentVisitor", "visitAssignmentExpression"));
        }
    }

    private static class SuspiciousIntegerDivAssignmentFix
    extends InspectionGadgetsFix {
        private SuspiciousIntegerDivAssignmentFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiAssignmentExpression expression2 = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiAssignmentExpression.class);
            if (expression2 == null) {
                return;
            }
            PsiJavaToken token = expression2.getOperationSign();
            IElementType tokenType = token.getTokenType();
            if (!JavaTokenType.ASTERISKEQ.equals(tokenType) && !JavaTokenType.DIVEQ.equals(tokenType)) {
                return;
            }
            PsiBinaryExpression rhs = SuspiciousIntegerDivAssignmentInspection.getRhs(expression2);
            if (rhs == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            PsiExpression operand2 = rhs.getLOperand();
            Number number = JavaPsiMathUtil.getNumberFromLiteral(operand2);
            if (number != null) {
                PsiReplacementUtil.replaceExpression(operand2, number + ".0", tracker);
            } else {
                PsiReplacementUtil.replaceExpression(operand2, "(double)" + operand2.getText(), tracker);
            }
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("suspicious.integer.div.assignment.quickfix", new Object[0]);
            if (string == null) {
                SuspiciousIntegerDivAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousIntegerDivAssignmentInspection$SuspiciousIntegerDivAssignmentFix", "getFamilyName"));
        }
    }
}

