/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class TextLabelInSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("text.label.in.switch.statement.problem.descriptor", infos[0] instanceof PsiSwitchStatement ? 1 : 2);
        if (string == null) {
            TextLabelInSwitchStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TextLabelInSwitchStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/TextLabelInSwitchStatementInspection", "buildErrorString"));
    }

    private static class TextLabelInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private TextLabelInSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                TextLabelInSwitchStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            this.visitSwitchBlock((PsiSwitchBlock)statement);
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            super.visitSwitchExpression(expression2);
            this.visitSwitchBlock((PsiSwitchBlock)expression2);
        }

        private void visitSwitchBlock(PsiSwitchBlock block) {
            PsiCodeBlock body2 = block.getBody();
            if (body2 == null) {
                return;
            }
            for (PsiStatement statement : body2.getStatements()) {
                if (!(statement instanceof PsiLabeledStatement)) continue;
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
                this.registerError((PsiElement)labeledStatement.getLabelIdentifier(), block);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/TextLabelInSwitchStatementInspection$TextLabelInSwitchStatementVisitor", "visitSwitchStatement"));
        }
    }
}

