/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.callMatcher;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;

public class CallMapper<T> {
    private final Map<String, List<CallHandler<T>>> myMap = new LinkedHashMap<String, List<CallHandler<T>>>();

    public CallMapper() {
    }

    @SafeVarargs
    public CallMapper(CallHandler<T> ... handlers) {
        for (CallHandler<T> handler : handlers) {
            this.register(handler);
        }
    }

    public CallMapper<T> register(CallHandler<T> handler) {
        handler.matcher().names().forEach(name2 -> this.myMap.computeIfAbsent((String)name2, k -> new ArrayList()).add(handler));
        return this;
    }

    public CallMapper<T> register(CallMatcher matcher, Function<? super PsiMethodCallExpression, ? extends T> handler) {
        return this.register(CallHandler.of(matcher, handler));
    }

    public CallMapper<T> register(CallMatcher matcher, T value2) {
        return this.register(CallHandler.of(matcher, call -> value2));
    }

    public CallMapper<T> registerAll(List<? extends CallHandler<T>> handlers) {
        handlers.forEach(this::register);
        return this;
    }

    @Contract(value="null -> null")
    public T mapFirst(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(call.getMethodExpression().getReferenceName());
        if (functions == null) {
            return null;
        }
        for (Function function : functions) {
            Object t = function.apply(call);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    @Contract(value="null -> null")
    public T mapFirst(PsiMethodReferenceExpression methodRef) {
        if (methodRef == null) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(methodRef.getReferenceName());
        if (functions == null) {
            return null;
        }
        for (CallHandler<T> function : functions) {
            T t = function.applyMethodReference(methodRef);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Contract(value="null -> null")
    public T mapFirst(PsiMethod method) {
        if (method == null) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(method.getName());
        if (functions == null) {
            return null;
        }
        for (CallHandler<T> function : functions) {
            T t = function.applyMethod(method);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public Stream<T> mapAll(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        List<CallHandler<T>> functions = this.myMap.get(call.getMethodExpression().getReferenceName());
        if (functions == null) {
            return StreamEx.empty();
        }
        return StreamEx.of(functions).map(fn -> fn.apply(call)).nonNull();
    }
}

