/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class PointlessIndexOfComparisonInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiBinaryExpression expression2 = (PsiBinaryExpression)infos[0];
        PsiExpression lhs = expression2.getLOperand();
        PsiJavaToken sign = expression2.getOperationSign();
        boolean value2 = lhs instanceof PsiMethodCallExpression ? PointlessIndexOfComparisonInspection.createContainsExpressionValue(sign, false) : PointlessIndexOfComparisonInspection.createContainsExpressionValue(sign, true);
        if (value2) {
            String string = InspectionGadgetsBundle.message("pointless.indexof.comparison.always.true.problem.descriptor", new Object[0]);
            if (string == null) {
                PointlessIndexOfComparisonInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("pointless.indexof.comparison.always.false.problem.descriptor", new Object[0]);
        if (string == null) {
            PointlessIndexOfComparisonInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    static boolean createContainsExpressionValue(@NotNull PsiJavaToken sign, boolean flipped) {
        IElementType tokenType;
        if (sign == null) {
            PointlessIndexOfComparisonInspection.$$$reportNull$$$0(2);
        }
        if ((tokenType = sign.getTokenType()).equals(JavaTokenType.EQEQ)) {
            return false;
        }
        if (tokenType.equals(JavaTokenType.NE)) {
            return true;
        }
        return !(flipped ? tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE) : tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessIndexOfComparisonVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/PointlessIndexOfComparisonInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/PointlessIndexOfComparisonInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createContainsExpressionValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PointlessIndexOfComparisonVisitor
    extends BaseInspectionVisitor {
        private PointlessIndexOfComparisonVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            PsiJavaToken sign;
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiJavaToken sign2 = expression2.getOperationSign();
                if (PointlessIndexOfComparisonVisitor.isPointLess(lhs, sign2, rhs, false)) {
                    this.registerError((PsiElement)expression2, expression2);
                }
            } else if (rhs instanceof PsiMethodCallExpression && PointlessIndexOfComparisonVisitor.isPointLess(rhs, sign = expression2.getOperationSign(), lhs, true)) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }

        private static boolean isPointLess(PsiExpression lhs, PsiJavaToken sign, PsiExpression rhs, boolean flipped) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            if (!PointlessIndexOfComparisonVisitor.isIndexOfCall(callExpression)) {
                return false;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            IElementType tokenType = sign.getTokenType();
            if (tokenType == null) {
                return false;
            }
            if (flipped) {
                if (constant < 0 && (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.LE))) {
                    return true;
                }
                if (constant < -1 && (tokenType.equals(JavaTokenType.GE) || tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.EQEQ))) {
                    return true;
                }
            } else {
                if (constant < 0 && (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.GE))) {
                    return true;
                }
                if (constant < -1 && (tokenType.equals(JavaTokenType.LE) || tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.NE) || tokenType.equals(JavaTokenType.EQEQ))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isIndexOfCall(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                PointlessIndexOfComparisonVisitor.$$$reportNull$$$0(0);
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            return "indexOf".equals(methodName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/PointlessIndexOfComparisonInspection$PointlessIndexOfComparisonVisitor", "isIndexOfCall"));
        }
    }
}

