/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassWithTooManyDependentsInspection
extends BaseGlobalInspection {
    public int limit = 10;

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            ClassWithTooManyDependentsInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            ClassWithTooManyDependentsInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            ClassWithTooManyDependentsInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            ClassWithTooManyDependentsInspection.$$$reportNull$$$0(3);
        }
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        PsiElement aClass = refClass.getPsiElement();
        if (!(aClass instanceof PsiClass) || ClassUtils.isInnerClass((PsiClass)aClass)) {
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        int numDependents = dependents.size();
        if (numDependents <= this.limit) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("class.with.too.many.dependents.problem.descriptor", refEntity.getName(), numDependents, this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("class.with.too.many.dependents.max.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "globalInspectionContext";
                break;
            }
        }
        objectArray[1] = "com/siyeh/ig/dependency/ClassWithTooManyDependentsInspection";
        objectArray[2] = "checkElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

