/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.encapsulation.ReplaceWithCloneFix;
import com.siyeh.ig.encapsulation.ReturnOfCollectionFieldFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentOrReturnOfFieldWithMutableTypeInspection
extends BaseInspection {
    public static final String[] MUTABLE_TYPES = new String[]{"java.util.Date", "java.util.Calendar", "java.util.Collection", "java.util.Map", "com.google.common.collect.Multimap", "com.google.common.collect.Table"};
    public boolean ignorePrivateMethods = true;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        PsiExpression rhs = (PsiExpression)infos[1];
        PsiType type2 = field.getType();
        boolean assignment = (Boolean)infos[3];
        String string = assignment ? InspectionGadgetsBundle.message("assignment.of.field.with.mutable.type.problem.descriptor", type2.getPresentableText(), field.getName(), rhs.getText()) : InspectionGadgetsBundle.message("return.of.field.with.mutable.type.problem.descriptor", type2.getPresentableText(), field.getName());
        if (string == null) {
            AssignmentOrReturnOfFieldWithMutableTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression returnValue = (PsiReferenceExpression)infos[1];
        String type2 = (String)infos[2];
        if ("java.util.Date".equals(type2) || "java.util.Calendar".equals(type2) || returnValue.getType() instanceof PsiArrayType) {
            PsiField field = (PsiField)infos[0];
            return new ReplaceWithCloneFix(field.getName());
        }
        boolean assignment = (Boolean)infos[3];
        if (!assignment) {
            return ReturnOfCollectionFieldFix.build(returnValue);
        }
        return null;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.private.methods.option", new Object[0]), (InspectionProfileEntry)this, "ignorePrivateMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentOrReturnOfFieldWithMutableTypeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/encapsulation/AssignmentOrReturnOfFieldWithMutableTypeInspection", "buildErrorString"));
    }

    private class AssignmentOrReturnOfFieldWithMutableTypeVisitor
    extends BaseInspectionVisitor {
        private AssignmentOrReturnOfFieldWithMutableTypeVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                AssignmentOrReturnOfFieldWithMutableTypeVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.EQ.equals(tokenType)) {
                return;
            }
            PsiExpression lhs = PsiUtil.deparenthesizeExpression((PsiExpression)expression2.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            String type2 = TypeUtils.expressionHasTypeOrSubtype(lhs, MUTABLE_TYPES);
            if (type2 == null && !(lhs.getType() instanceof PsiArrayType)) {
                return;
            }
            PsiExpression rhs = PsiUtil.deparenthesizeExpression((PsiExpression)expression2.getRExpression());
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiField field = (PsiField)ObjectUtils.tryCast((Object)((PsiReference)lhs).resolve(), PsiField.class);
            if (field == null) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)ObjectUtils.tryCast((Object)((PsiReference)rhs).resolve(), PsiParameter.class);
            if (parameter2 == null || !(parameter2.getDeclarationScope() instanceof PsiMethod) || ClassUtils.isImmutable(parameter2.getType())) {
                return;
            }
            if (AssignmentOrReturnOfFieldWithMutableTypeInspection.this.ignorePrivateMethods) {
                PsiClass containingClass;
                PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
                if (containingMethod == null || containingMethod.hasModifierProperty("private")) {
                    return;
                }
                if (containingMethod.isConstructor() && (containingClass = containingMethod.getContainingClass()) != null && containingClass.hasModifierProperty("private")) {
                    return;
                }
            }
            this.registerError((PsiElement)rhs, field, rhs, type2, Boolean.TRUE);
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                AssignmentOrReturnOfFieldWithMutableTypeVisitor.$$$reportNull$$$0(1);
            }
            super.visitReturnStatement(statement);
            PsiExpression returnValue = PsiUtil.deparenthesizeExpression((PsiExpression)statement.getReturnValue());
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (AssignmentOrReturnOfFieldWithMutableTypeInspection.this.ignorePrivateMethods && element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("private")) {
                return;
            }
            PsiField field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)returnValue).resolve(), PsiField.class);
            if (field == null) {
                return;
            }
            String type2 = TypeUtils.expressionHasTypeOrSubtype(returnValue, MUTABLE_TYPES);
            if (type2 == null && !(returnValue.getType() instanceof PsiArrayType)) {
                return;
            }
            if (CollectionUtils.isConstantEmptyArray(field) || field.hasModifierProperty("final") && field.hasModifierProperty("static") && field.getType() instanceof PsiArrayType && field.getInitializer() == null || ClassUtils.isImmutable(field.getType()) || Mutability.getMutability((PsiModifierListOwner)field).isUnmodifiable()) {
                return;
            }
            this.registerError((PsiElement)returnValue, field, returnValue, type2, Boolean.FALSE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/encapsulation/AssignmentOrReturnOfFieldWithMutableTypeInspection$AssignmentOrReturnOfFieldWithMutableTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

