/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.SideEffectVisitor;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatchMayIgnoreExceptionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String IGNORED_PARAMETER_NAME = "ignored";
    public boolean m_ignoreCatchBlocksWithComments = true;
    public boolean m_ignoreNonEmptyCatchBlock = true;
    public boolean m_ignoreUsedIgnoredName = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.catch.ignores.exception.option.comments", new Object[0]), "m_ignoreCatchBlocksWithComments");
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.catch.ignores.exception.option.nonempty", new Object[0]), "m_ignoreNonEmptyCatchBlock");
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.catch.ignores.exception.option.ignored.used", new Object[0]), "m_ignoreUsedIgnoredName");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CatchMayIgnoreExceptionInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitTryStatement(PsiTryStatement statement) {
                PsiCatchSection[] catchSections;
                super.visitTryStatement(statement);
                for (PsiCatchSection section : catchSections = statement.getCatchSections()) {
                    this.checkCatchSection(section);
                }
            }

            private void checkCatchSection(PsiCatchSection section) {
                PsiParameter parameter2 = section.getParameter();
                if (parameter2 == null) {
                    return;
                }
                PsiIdentifier identifier = parameter2.getNameIdentifier();
                if (identifier == null) {
                    return;
                }
                String parameterName = parameter2.getName();
                if (PsiUtil.isIgnoredName((String)parameterName)) {
                    if (!CatchMayIgnoreExceptionInspection.this.m_ignoreUsedIgnoredName && VariableAccessUtils.variableIsUsed((PsiVariable)parameter2, (PsiElement)section)) {
                        holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message("inspection.catch.ignores.exception.used.message", new Object[0]), new LocalQuickFix[0]);
                    }
                    return;
                }
                if ((parameterName.equals("expected") || parameterName.equals("ok")) && TestUtils.isInTestSourceContent((PsiElement)section)) {
                    return;
                }
                PsiElement catchToken = section.getFirstChild();
                if (catchToken == null) {
                    return;
                }
                PsiCodeBlock block = section.getCatchBlock();
                if (block == null) {
                    return;
                }
                SuppressForTestsScopeFix fix2 = SuppressForTestsScopeFix.build(CatchMayIgnoreExceptionInspection.this, (PsiElement)section);
                if (ControlFlowUtils.isEmpty((PsiElement)block, CatchMayIgnoreExceptionInspection.this.m_ignoreCatchBlocksWithComments, true)) {
                    RenameCatchParameterFix renameFix = new RenameCatchParameterFix(CatchMayIgnoreExceptionInspection.generateName(block));
                    AddCatchBodyFix addBodyFix = this.getAddBodyFix(block);
                    holder.registerProblem(catchToken, InspectionGadgetsBundle.message("inspection.catch.ignores.exception.empty.message", new Object[0]), new LocalQuickFix[]{renameFix, addBodyFix, fix2});
                } else if (!VariableAccessUtils.variableIsUsed((PsiVariable)parameter2, (PsiElement)section)) {
                    if (!(CatchMayIgnoreExceptionInspection.this.m_ignoreNonEmptyCatchBlock || CatchMayIgnoreExceptionInspection.this.m_ignoreCatchBlocksWithComments && PsiTreeUtil.getChildOfType((PsiElement)block, PsiComment.class) != null)) {
                        holder.registerProblem((PsiElement)identifier, InspectionGadgetsBundle.message("inspection.catch.ignores.exception.unused.message", new Object[0]), new LocalQuickFix[]{new RenameFix(CatchMayIgnoreExceptionInspection.generateName(block), false, false), fix2});
                    }
                } else if (this.mayIgnoreVMException(parameter2, block)) {
                    holder.registerProblem(catchToken, InspectionGadgetsBundle.message("inspection.catch.ignores.exception.vm.ignored.message", new Object[0]), new LocalQuickFix[]{fix2});
                }
            }

            @Nullable
            private AddCatchBodyFix getAddBodyFix(PsiCodeBlock block) {
                if (ControlFlowUtils.isEmpty((PsiElement)block, true, true)) {
                    try {
                        FileTemplate template = FileTemplateManager.getInstance((Project)holder.getProject()).getCodeTemplate("Catch Statement Body.java");
                        if (!StringUtil.isEmptyOrSpaces((String)template.getText())) {
                            return new AddCatchBodyFix();
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return null;
            }

            private boolean mayIgnoreVMException(final PsiParameter parameter2, final PsiCodeBlock block) {
                PsiType type2 = parameter2.getType();
                if (!(type2.equalsToText("java.lang.Throwable") || type2.equalsToText("java.lang.Exception") || type2.equalsToText("java.lang.RuntimeException") || type2.equalsToText("java.lang.Error"))) {
                    return false;
                }
                String className2 = type2.equalsToText("java.lang.Error") ? "java.lang.StackOverflowError" : "java.lang.NullPointerException";
                final PsiClassType exception = JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createTypeByFQClassName(className2, parameter2.getResolveScope());
                PsiClass exceptionClass = exception.resolve();
                if (exceptionClass == null) {
                    return false;
                }
                class CatchDataFlowRunner
                extends DataFlowRunner {
                    final DfaVariableValue myExceptionVar;
                    final DfaVariableValue myStableExceptionVar;

                    CatchDataFlowRunner() {
                        super(holder.getProject(), (PsiElement)psiCodeBlock);
                        DfaValueFactory factory = this.getFactory();
                        this.myExceptionVar = factory.getVarFactory().createVariableValue((PsiVariable)parameter2);
                        this.myStableExceptionVar = factory.getVarFactory().createVariableValue(new LightParameter("tmp", (PsiType)exception, (PsiElement)block));
                    }

                    @Override
                    @NotNull
                    protected List<DfaInstructionState> createInitialInstructionStates(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> memStates, @NotNull ControlFlow flow) {
                        if (psiBlock == null) {
                            CatchDataFlowRunner.$$$reportNull$$$0(0);
                        }
                        if (memStates == null) {
                            CatchDataFlowRunner.$$$reportNull$$$0(1);
                        }
                        if (flow == null) {
                            CatchDataFlowRunner.$$$reportNull$$$0(2);
                        }
                        DfaValueFactory factory = this.getFactory();
                        for (DfaMemoryState dfaMemoryState : memStates) {
                            dfaMemoryState.applyCondition(this.myExceptionVar.eq(this.myStableExceptionVar));
                            dfaMemoryState.applyCondition(this.myExceptionVar.cond(RelationType.IS, factory.getObjectType((PsiType)exception, Nullability.NOT_NULL)));
                        }
                        List<DfaInstructionState> list = super.createInitialInstructionStates(psiBlock, memStates, flow);
                        if (list == null) {
                            CatchDataFlowRunner.$$$reportNull$$$0(3);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 3: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 3: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "psiBlock";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "memStates";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "flow";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection$1$1CatchDataFlowRunner";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection$1$1CatchDataFlowRunner";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createInitialInstructionStates";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "createInitialInstructionStates";
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 3: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                }
                CatchDataFlowRunner runner = new CatchDataFlowRunner();
                IgnoredExceptionVisitor visitor2 = new IgnoredExceptionVisitor(parameter2, block, exceptionClass, runner.myStableExceptionVar);
                return runner.analyzeCodeBlock(block, visitor2) == RunnerResult.OK;
            }
        };
    }

    @NotNull
    private static String generateName(PsiCodeBlock block) {
        String string = new VariableNameGenerator((PsiElement)block, VariableKind.LOCAL_VARIABLE).byName(IGNORED_PARAMETER_NAME).generate(true);
        if (string == null) {
            CatchMayIgnoreExceptionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RenameCatchParameterFix
    implements LocalQuickFix {
        private final String myName;

        private RenameCatchParameterFix(String name2) {
            this.myName = name2;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("rename.catch.parameter.to.ignored", this.myName);
            if (string == null) {
                RenameCatchParameterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("rename.catch.parameter.to.ignored", CatchMayIgnoreExceptionInspection.IGNORED_PARAMETER_NAME);
            if (string == null) {
                RenameCatchParameterFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                RenameCatchParameterFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RenameCatchParameterFix.$$$reportNull$$$0(3);
            }
            if (!((parent = (element = descriptor.getPsiElement()).getParent()) instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)parent;
            PsiParameter parameter2 = catchSection.getParameter();
            if (parameter2 == null) {
                return;
            }
            PsiIdentifier identifier = parameter2.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiIdentifier newIdentifier = factory.createIdentifier(this.myName);
            identifier.replace((PsiElement)newIdentifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection$RenameCatchParameterFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection$RenameCatchParameterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddCatchBodyFix
    implements LocalQuickFix,
    LowPriorityAction {
        private AddCatchBodyFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.empty.catch.block.generate.body", new Object[0]);
            if (string == null) {
                AddCatchBodyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiCatchSection catchSection;
            if (project == null) {
                AddCatchBodyFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddCatchBodyFix.$$$reportNull$$$0(2);
            }
            if ((catchSection = (PsiCatchSection)ObjectUtils.tryCast((Object)descriptor.getPsiElement().getParent(), PsiCatchSection.class)) == null) {
                return;
            }
            PsiParameter parameter2 = catchSection.getParameter();
            if (parameter2 == null) {
                return;
            }
            String parameterName = parameter2.getName();
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getCodeTemplate("Catch Statement Body.java");
            Properties props = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            props.setProperty("EXCEPTION", parameterName);
            props.setProperty("EXCEPTION_TYPE", parameter2.getType().getCanonicalText());
            PsiDirectory directory = catchSection.getContainingFile().getContainingDirectory();
            if (directory != null) {
                JavaTemplateUtil.setPackageNameAttribute(props, directory);
            }
            try {
                PsiCodeBlock block = PsiElementFactory.getInstance((Project)project).createCodeBlockFromText("{\n" + template.getText(props) + "\n}", null);
                Objects.requireNonNull(catchSection.getCatchBlock()).replace((PsiElement)block);
            }
            catch (ProcessCanceledException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new IncorrectOperationException("Incorrect file template", (Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection$AddCatchBodyFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection$AddCatchBodyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class IgnoredExceptionVisitor
    extends SideEffectVisitor {
        @NotNull
        private final PsiParameter myParameter;
        @NotNull
        private final PsiCodeBlock myBlock;
        @NotNull
        private final List<PsiMethod> myMethods;
        @NotNull
        private final DfaVariableValue myExceptionVar;

        IgnoredExceptionVisitor(@NotNull PsiParameter parameter2, @NotNull PsiCodeBlock block, @NotNull PsiClass exceptionClass, @NotNull DfaVariableValue exceptionVar) {
            if (parameter2 == null) {
                IgnoredExceptionVisitor.$$$reportNull$$$0(0);
            }
            if (block == null) {
                IgnoredExceptionVisitor.$$$reportNull$$$0(1);
            }
            if (exceptionClass == null) {
                IgnoredExceptionVisitor.$$$reportNull$$$0(2);
            }
            if (exceptionVar == null) {
                IgnoredExceptionVisitor.$$$reportNull$$$0(3);
            }
            this.myParameter = parameter2;
            this.myBlock = block;
            this.myExceptionVar = exceptionVar;
            this.myMethods = ((StreamEx)StreamEx.of((Object[])new String[]{"getMessage", "getLocalizedMessage", "getCause"}).flatArray(name2 -> exceptionClass.findMethodsByName(name2, true)).filter(m -> m.getParameterList().isEmpty())).toList();
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            DfaValue qualifier;
            if (this.myMethods.contains(instruction.getTargetMethod()) && memState.areEqual(qualifier = memState.peek(), this.myExceptionVar)) {
                memState.pop();
                memState.push(runner.getFactory().getNull());
                return IgnoredExceptionVisitor.nextInstruction(instruction, runner, memState);
            }
            return super.visitMethodCall(instruction, runner, memState);
        }

        @Override
        protected boolean isModificationAllowed(DfaVariableValue variable) {
            PsiModifierListOwner owner2 = variable.getPsiVariable();
            return owner2 == this.myParameter || owner2 != null && PsiTreeUtil.isAncestor((PsiElement)this.myBlock, (PsiElement)owner2, (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "block";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exceptionClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exceptionVar";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/errorhandling/CatchMayIgnoreExceptionInspection$IgnoredExceptionVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

