/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowFromFinallyBlockInspection
extends BaseInspection {
    public boolean warnOnAllExceptions = false;

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("throw,from.finally.block.everywhere.option", new Object[0]), (InspectionProfileEntry)this, "warnOnAllExceptions");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            String string = InspectionGadgetsBundle.message("throw.from.finally.block.problem.descriptor", new Object[0]);
            if (string == null) {
                ThrowFromFinallyBlockInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        PsiClassType type2 = (PsiClassType)infos[0];
        String string = InspectionGadgetsBundle.message("possible.throw.from.finally.block.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            ThrowFromFinallyBlockInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowFromFinallyBlockVisitor();
    }

    private static PsiCodeBlock getContainingFinallyBlock(@NotNull PsiElement element, @NotNull PsiType thrownType) {
        if (element == null) {
            ThrowFromFinallyBlockInspection.$$$reportNull$$$0(2);
        }
        if (thrownType == null) {
            ThrowFromFinallyBlockInspection.$$$reportNull$$$0(3);
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)currentElement, (boolean)true)) {
                return finallyBlock;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)tryStatement.getTryBlock(), (PsiElement)currentElement, (boolean)true) && ThrowFromFinallyBlockInspection.isCaught(tryStatement, thrownType)) {
                return null;
            }
            currentElement = tryStatement;
        }
        return null;
    }

    private static boolean isCaught(PsiTryStatement tryStatement, PsiType exceptionType) {
        for (PsiParameter parameter2 : tryStatement.getCatchBlockParameters()) {
            PsiType type2 = parameter2.getType();
            if (!type2.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thrownType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFinallyBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ThrowFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ThrowFromFinallyBlockVisitor() {
        }

        public void visitCallExpression(PsiCallExpression expression2) {
            super.visitCallExpression(expression2);
            if (!ThrowFromFinallyBlockInspection.this.warnOnAllExceptions) {
                return;
            }
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions((PsiElement)expression2);
            if (exceptions.isEmpty()) {
                return;
            }
            for (PsiClassType exception : exceptions) {
                PsiCodeBlock finallyBlock = ThrowFromFinallyBlockInspection.getContainingFinallyBlock((PsiElement)expression2, (PsiType)exception);
                if (finallyBlock == null || !this.isHidingOfPreviousException(finallyBlock, (PsiElement)expression2)) continue;
                if (expression2 instanceof PsiMethodCallExpression) {
                    this.registerMethodCallError((PsiMethodCallExpression)expression2, exception);
                } else if (expression2 instanceof PsiNewExpression) {
                    this.registerNewExpressionError((PsiNewExpression)expression2, exception);
                }
                return;
            }
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            super.visitThrowStatement(statement);
            PsiExpression exception = ParenthesesUtils.stripParentheses(statement.getException());
            if (exception == null) {
                return;
            }
            PsiType type2 = exception.getType();
            if (type2 == null) {
                return;
            }
            PsiCodeBlock finallyBlock = ThrowFromFinallyBlockInspection.getContainingFinallyBlock((PsiElement)statement, type2);
            if (finallyBlock == null) {
                return;
            }
            if (exception instanceof PsiReferenceExpression && ((target = (referenceExpression = (PsiReferenceExpression)exception).resolve()) == null || !PsiTreeUtil.isAncestor((PsiElement)finallyBlock, (PsiElement)target, (boolean)true))) {
                return;
            }
            if (this.isHidingOfPreviousException(finallyBlock, (PsiElement)statement)) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            }
        }

        private boolean isHidingOfPreviousException(PsiCodeBlock finallyBlock, PsiElement throwElement) {
            PsiElement parent = finallyBlock.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return false;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
            if (catchBlocks.length == 0) {
                return true;
            }
            PsiIfStatement ifStatement = this.getParentOfType(throwElement, PsiIfStatement.class, (PsiElement)finallyBlock);
            if (ifStatement == null) {
                return true;
            }
            boolean inThenBranch = PsiTreeUtil.isAncestor((PsiElement)ifStatement.getThenBranch(), (PsiElement)throwElement, (boolean)false);
            boolean inElseBranch = PsiTreeUtil.isAncestor((PsiElement)ifStatement.getElseBranch(), (PsiElement)throwElement, (boolean)false);
            if (!inThenBranch && !inElseBranch) {
                return true;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(condition2, inThenBranch);
            if (variable == null) {
                return true;
            }
            boolean assigned = true;
            for (PsiCodeBlock catchBlock : catchBlocks) {
                assigned &= VariableAccessUtils.variableIsAssigned(variable, (PsiElement)catchBlock);
            }
            return !assigned;
        }

        @Nullable
        public <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, @NotNull PsiElement stopAt) {
            if (aClass == null) {
                ThrowFromFinallyBlockVisitor.$$$reportNull$$$0(0);
            }
            if (stopAt == null) {
                ThrowFromFinallyBlockVisitor.$$$reportNull$$$0(1);
            }
            if (element == null || element instanceof PsiFile) {
                return null;
            }
            for (element = element.getParent(); element != null && !aClass.isInstance(element); element = element.getParent()) {
                if (element != stopAt && !(element instanceof PsiFile)) continue;
                return null;
            }
            return (T)element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stopAt";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection$ThrowFromFinallyBlockVisitor";
            objectArray[2] = "getParentOfType";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

