/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.BaseSwitchFix;
import com.siyeh.ig.psiutils.CreateSwitchBranchesUtil;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CreateMissingSwitchBranchesFix
extends BaseSwitchFix {
    private final Set<String> myNames;

    public CreateMissingSwitchBranchesFix(@NotNull PsiSwitchBlock block, Set<String> names2) {
        if (block == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(0);
        }
        super(block);
        this.myNames = names2;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = CreateSwitchBranchesUtil.getActionName(this.myNames);
        if (string == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("create.missing.switch.branches.fix.family.name", new Object[0]);
        if (string == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void invoke() {
        PsiSwitchBlock switchBlock = (PsiSwitchBlock)this.myBlock.getElement();
        if (switchBlock == null) {
            return;
        }
        PsiExpression switchExpression = switchBlock.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiClassType switchType = (PsiClassType)switchExpression.getType();
        if (switchType == null) {
            return;
        }
        PsiClass enumClass = switchType.resolve();
        if (enumClass == null) {
            return;
        }
        List allEnumConstants = StreamEx.of((Object[])enumClass.getAllFields()).select(PsiEnumConstant.class).map(PsiField::getName).toList();
        Function<PsiSwitchLabelStatementBase, List<String>> caseExtractor = label -> ContainerUtil.map(SwitchUtils.findEnumConstants(label), PsiField::getName);
        List<PsiSwitchLabelStatementBase> addedLabels = CreateSwitchBranchesUtil.createMissingBranches(switchBlock, allEnumConstants, this.myNames, caseExtractor);
        CreateSwitchBranchesUtil.createTemplate(switchBlock, addedLabels);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/CreateMissingSwitchBranchesFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/CreateMissingSwitchBranchesFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

