/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

public class JavaLangImportInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("java.lang.import.problem.descriptor", new Object[0]);
        if (string == null) {
            JavaLangImportInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JavaLangImportVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/JavaLangImportInspection", "buildErrorString"));
    }

    private static class JavaLangImportVisitor
    extends BaseInspectionVisitor {
        private JavaLangImportVisitor() {
        }

        public void visitImportStatement(PsiImportStatement statement) {
            super.visitImportStatement(statement);
            PsiJavaCodeReferenceElement reference = statement.getImportReference();
            if (reference == null) {
                return;
            }
            String text2 = statement.getQualifiedName();
            if (text2 == null) {
                return;
            }
            if (statement.isOnDemand()) {
                if ("java.lang".equals(text2)) {
                    this.registerError((PsiElement)statement, new Object[0]);
                }
            } else {
                int classNameIndex = text2.lastIndexOf(46);
                if (classNameIndex < 0) {
                    return;
                }
                String parentName = text2.substring(0, classNameIndex);
                if (!"java.lang".equals(parentName)) {
                    return;
                }
                if (ImportUtils.hasOnDemandImportConflict(text2, (PsiElement)statement)) {
                    return;
                }
                this.registerError((PsiElement)statement, new Object[0]);
            }
        }
    }
}

