/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ExtendsAnnotationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ClassExplicitlyAnnotation";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass containingClass = (PsiClass)infos[0];
        String string = containingClass.isInterface() ? InspectionGadgetsBundle.message("extends.annotation.interface.problem.descriptor", containingClass.getName()) : InspectionGadgetsBundle.message("extends.annotation.problem.descriptor", containingClass.getName());
        if (string == null) {
            ExtendsAnnotationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ExtendsAnnotationInspection", "buildErrorString"));
    }

    private static class ExtendsAnnotationVisitor
    extends BaseInspectionVisitor {
        private ExtendsAnnotationVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ExtendsAnnotationVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isAnnotationType() || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javax.enterprise.util.AnnotationLiteral")) {
                return;
            }
            this.checkReferenceList(aClass.getExtendsList(), aClass);
            this.checkReferenceList(aClass.getImplementsList(), aClass);
        }

        private void checkReferenceList(PsiReferenceList referenceList, PsiClass containingClass) {
            PsiJavaCodeReferenceElement[] elements;
            if (referenceList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement element : elements = referenceList.getReferenceElements()) {
                PsiClass psiClass;
                PsiElement referent = element.resolve();
                if (!(referent instanceof PsiClass) || !(psiClass = (PsiClass)referent).isAnnotationType()) continue;
                this.registerError((PsiElement)element, containingClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/ExtendsAnnotationInspection$ExtendsAnnotationVisitor", "visitClass"));
        }
    }
}

