/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class StaticSuiteInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "SuiteNotDeclaredStatic";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.suite.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticSuiteInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticSuiteVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/StaticSuiteInspection", "buildErrorString"));
    }

    private static class StaticSuiteVisitor
    extends BaseInspectionVisitor {
        private StaticSuiteVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String methodName;
            if (method == null) {
                StaticSuiteVisitor.$$$reportNull$$$0(0);
            }
            if (!"suite".equals(methodName = method.getName())) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"junit.framework.TestCase")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/StaticSuiteInspection$StaticSuiteVisitor", "visitMethod"));
        }
    }
}

