/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawUseOfParameterizedTypeInspection
extends BaseInspection {
    public boolean ignoreObjectConstruction = false;
    public boolean ignoreTypeCasts = false;
    public boolean ignoreUncompilable = true;
    public boolean ignoreParametersOfOverridingMethods = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "rawtypes";
    }

    @Nullable
    public String getAlternativeID() {
        return "RawUseOfParameterized";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("raw.use.of.parameterized.type.problem.descriptor", new Object[0]);
        if (string == null) {
            RawUseOfParameterizedTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.new.objects.option", new Object[0]), "ignoreObjectConstruction");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.type.casts.option", new Object[0]), "ignoreTypeCasts");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.uncompilable.option", new Object[0]), "ignoreUncompilable");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("raw.use.of.parameterized.type.ignore.overridden.parameter.option", new Object[0]), "ignoreParametersOfOverridingMethods");
        return optionsPanel;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RawUseOfParameterizedTypeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/RawUseOfParameterizedTypeInspection", "buildErrorString"));
    }

    private class RawUseOfParameterizedTypeVisitor
    extends BaseInspectionVisitor {
        private RawUseOfParameterizedTypeVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                RawUseOfParameterizedTypeVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            if (RawUseOfParameterizedTypeInspection.this.ignoreObjectConstruction) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && expression2.isArrayCreation()) {
                return;
            }
            PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
            this.checkReferenceElement(classReference2);
        }

        public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
            PsiParameter parameter2;
            PsiElement declarationScope;
            PsiAnnotationMemberValue defaultValue;
            PsiType parentType;
            PsiType type2;
            if (typeElement == null) {
                RawUseOfParameterizedTypeVisitor.$$$reportNull$$$0(1);
            }
            if (!((type2 = typeElement.getType()) instanceof PsiClassType)) {
                return;
            }
            super.visitTypeElement(typeElement);
            PsiElement directParent = typeElement.getParent();
            if (RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && directParent instanceof PsiTypeElement && (parentType = ((PsiTypeElement)directParent).getType()) instanceof PsiArrayType && PsiTreeUtil.skipParentsOfType((PsiElement)directParent, (Class[])new Class[]{PsiTypeElement.class}) instanceof PsiMethodReferenceExpression) {
                return;
            }
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class, PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class});
            if (parent instanceof PsiTypeTestPattern || parent instanceof PsiClassObjectAccessExpression) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreTypeCasts && parent instanceof PsiTypeCastExpression) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiComment.class) != null) {
                return;
            }
            if (RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && parent instanceof PsiAnnotationMethod && (defaultValue = ((PsiAnnotationMethod)parent).getDefaultValue()) != null && directParent instanceof PsiTypeElement) {
                return;
            }
            if (parent instanceof PsiParameter && (declarationScope = (parameter2 = (PsiParameter)parent).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)declarationScope;
                if (RawUseOfParameterizedTypeInspection.this.ignoreParametersOfOverridingMethods ? MethodUtils.getSuper(method) != null || MethodCallUtils.isUsedAsSuperConstructorCallArgument(parameter2, false) : RawUseOfParameterizedTypeInspection.this.ignoreUncompilable && (LibraryUtil.isOverrideOfLibraryMethod(method) || MethodCallUtils.isUsedAsSuperConstructorCallArgument(parameter2, true))) {
                    return;
                }
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            this.checkReferenceElement(referenceElement);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            PsiElement referenceParent = reference.getParent();
            if (!(referenceParent instanceof PsiReferenceList)) {
                return;
            }
            PsiReferenceList referenceList = (PsiReferenceList)referenceParent;
            PsiElement listParent = referenceList.getParent();
            if (!(listParent instanceof PsiClass)) {
                return;
            }
            this.checkReferenceElement(reference);
        }

        private void checkReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                return;
            }
            PsiType[] typeParameters = reference.getTypeParameters();
            if (typeParameters.length > 0) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            PsiElement qualifier = reference.getQualifier();
            if (qualifier instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement qualifierReference = (PsiJavaCodeReferenceElement)qualifier;
                if (!(aClass.hasModifierProperty("static") || aClass.isInterface() || aClass.isEnum())) {
                    this.checkReferenceElement(qualifierReference);
                }
            }
            if (!aClass.hasTypeParameters()) {
                return;
            }
            this.registerError((PsiElement)reference, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/RawUseOfParameterizedTypeInspection$RawUseOfParameterizedTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

