/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class ExceptionNameDoesntEndWithExceptionInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        return "ExceptionClassNameDoesntEndWithException";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("exception.name.doesnt.end.with.exception.problem.descriptor", new Object[0]);
        if (string == null) {
            ExceptionNameDoesntEndWithExceptionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExceptionNameDoesntEndWithExceptionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ExceptionNameDoesntEndWithExceptionInspection", "buildErrorString"));
    }

    private static class ExceptionNameDoesntEndWithExceptionVisitor
    extends BaseInspectionVisitor {
        private ExceptionNameDoesntEndWithExceptionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ExceptionNameDoesntEndWithExceptionVisitor.$$$reportNull$$$0(0);
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            String className2 = aClass.getName();
            if (className2 == null) {
                return;
            }
            String exception = "Exception";
            if (className2.endsWith("Exception")) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/naming/ExceptionNameDoesntEndWithExceptionInspection$ExceptionNameDoesntEndWithExceptionVisitor", "visitClass"));
        }
    }
}

