/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameDiffersFromOverriddenParameterInspection
extends BaseInspection {
    public boolean m_ignoreSingleCharacterNames = false;
    public boolean m_ignoreOverridesOfLibraryMethods = false;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.ignore.character.option", new Object[0]), "m_ignoreSingleCharacterNames");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.ignore.library.option", new Object[0]), "m_ignoreOverridesOfLibraryMethods");
        return optionsPanel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix((String)infos[0], false, false);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.problem.descriptor", infos[0]);
        if (string == null) {
            ParameterNameDiffersFromOverriddenParameterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterNameDiffersFromOverriddenParameterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspection", "buildErrorString"));
    }

    private class ParameterNameDiffersFromOverriddenParameterVisitor
    extends BaseInspectionVisitor {
        private ParameterNameDiffersFromOverriddenParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameterList parameterList;
            if (method == null) {
                ParameterNameDiffersFromOverriddenParameterVisitor.$$$reportNull$$$0(0);
            }
            if ((parameterList = method.getParameterList()).isEmpty()) {
                return;
            }
            PsiMethod superMethod = MethodUtils.getSuper(method);
            if (superMethod == null) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.checkParameters(superMethod, parameters2);
        }

        private void checkParameters(@NotNull PsiMethod superMethod, PsiParameter[] parameters2) {
            PsiClass containingClass;
            if (superMethod == null) {
                ParameterNameDiffersFromOverriddenParameterVisitor.$$$reportNull$$$0(1);
            }
            if (ParameterNameDiffersFromOverriddenParameterInspection.this.m_ignoreOverridesOfLibraryMethods && (containingClass = superMethod.getContainingClass()) != null && LibraryUtil.classIsInLibrary(containingClass)) {
                return;
            }
            PsiParameterList superParameterList = superMethod.getParameterList();
            PsiParameter[] superParameters = superParameterList.getParameters();
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                String parameterName = parameter2.getName();
                String superParameterName = superParameters[i].getName();
                if (superParameterName.equals(parameterName) || ParameterNameDiffersFromOverriddenParameterInspection.this.m_ignoreSingleCharacterNames && superParameterName.length() == 1) continue;
                this.registerVariableError((PsiVariable)parameter2, superParameterName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superMethod";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspection$ParameterNameDiffersFromOverriddenParameterVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

