/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class UpperCaseFieldNameNotConstantInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        return "NonConstantFieldWithUpperCaseName";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("upper.case.field.name.not.constant.problem.descriptor", new Object[0]);
        if (string == null) {
            UpperCaseFieldNameNotConstantInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UpperCaseFieldNameNotConstantVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspection", "buildErrorString"));
    }

    private static class UpperCaseFieldNameNotConstantVisitor
    extends BaseInspectionVisitor {
        private UpperCaseFieldNameNotConstantVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                UpperCaseFieldNameNotConstantVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return;
            }
            String fieldName = field.getName();
            if (!fieldName.equals(StringUtil.toUpperCase((String)fieldName))) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspection$UpperCaseFieldNameNotConstantVisitor", "visitField"));
        }
    }
}

