/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;

public class ClassUnconnectedToPackageInspection
extends BaseGlobalInspection {
    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            ClassUnconnectedToPackageInspection.$$$reportNull$$$0(3);
        }
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        RefEntity owner2 = refClass.getOwner();
        if (!(owner2 instanceof RefPackage)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        for (RefClass refClass2 : dependencies) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, refClass2)) continue;
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, dependent)) continue;
            return null;
        }
        PsiElement psiElement = UDeclarationKt.getAnchorPsi((UDeclaration)refClass.getUastElement());
        if (psiElement == null) {
            return null;
        }
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor(psiElement, InspectionGadgetsBundle.message("class.unconnected.to.package.problem.descriptor", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
    }

    private static boolean inSamePackage(RefClass class1, RefClass class2) {
        return class1.getOwner() == class2.getOwner();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "globalInspectionContext";
                break;
            }
        }
        objectArray[1] = "com/siyeh/ig/packaging/ClassUnconnectedToPackageInspection";
        objectArray[2] = "checkElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

