/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.SmartList;
import com.siyeh.ig.ui.UiUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CollectionsListSettings {
    @NonNls
    public static final SortedSet<String> DEFAULT_COLLECTION_LIST;
    private final List<String> myCollectionClassesRequiringCapacity = new SmartList(this.getDefaultSettings());

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            CollectionsListSettings.$$$reportNull$$$0(0);
        }
        this.myCollectionClassesRequiringCapacity.clear();
        this.myCollectionClassesRequiringCapacity.addAll(this.getDefaultSettings());
        for (Element classElement : node.getChildren("cls")) {
            String className2 = classElement.getText();
            if (classElement.getAttributeValue("remove", Boolean.FALSE.toString()).equals(Boolean.TRUE.toString())) {
                this.myCollectionClassesRequiringCapacity.remove(className2);
                continue;
            }
            this.myCollectionClassesRequiringCapacity.add(className2);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            CollectionsListSettings.$$$reportNull$$$0(1);
        }
        HashSet<String> defaultToRemoveSettings = new HashSet<String>(this.getDefaultSettings());
        defaultToRemoveSettings.removeAll(this.myCollectionClassesRequiringCapacity);
        HashSet<String> toAdd = new HashSet<String>(this.myCollectionClassesRequiringCapacity);
        toAdd.removeAll(this.getDefaultSettings());
        for (String className2 : defaultToRemoveSettings) {
            node.addContent(new Element("cls").setText(className2).setAttribute("remove", Boolean.TRUE.toString()));
        }
        for (String className2 : toAdd) {
            node.addContent(new Element("cls").setText(className2));
        }
    }

    protected abstract Collection<String> getDefaultSettings();

    public Collection<String> getCollectionClassesRequiringCapacity() {
        return this.myCollectionClassesRequiringCapacity;
    }

    public JComponent createOptionsPanel() {
        String title = QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.options.title", new Object[0]);
        ListTable table = new ListTable(new ListWrappingTableModel(this.myCollectionClassesRequiringCapacity, title));
        return UiUtils.createAddRemoveTreeClassChooserPanel(table, title, "java.lang.Object");
    }

    static {
        TreeSet<String> set = new TreeSet<String>();
        set.add("java.util.concurrent.ConcurrentHashMap");
        set.add("java.util.concurrent.PriorityBlockingQueue");
        set.add("java.util.ArrayDeque");
        set.add("java.util.ArrayList");
        set.add("java.util.HashMap");
        set.add("java.util.Hashtable");
        set.add("java.util.HashSet");
        set.add("java.util.IdentityHashMap");
        set.add("java.util.LinkedHashMap");
        set.add("java.util.LinkedHashSet");
        set.add("java.util.PriorityQueue");
        set.add("java.util.Vector");
        set.add("java.util.WeakHashMap");
        DEFAULT_COLLECTION_LIST = Collections.unmodifiableSortedSet(set);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "node";
        objectArray2[1] = "com/siyeh/ig/performance/CollectionsListSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

