/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class LengthOneStringsInConcatenationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "SingleCharacterStringConcatenation";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        String escapedString = StringUtil.escapeStringCharacters((String)string);
        String string2 = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", escapedString);
        if (string2 == null) {
            LengthOneStringsInConcatenationInspection.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceStringsWithCharsFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LengthOneStringsInConcatenationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection", "buildErrorString"));
    }

    private static class LengthOneStringsInConcatenationVisitor
    extends BaseInspectionVisitor {
        private LengthOneStringsInConcatenationVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            if (expression2 == null) {
                LengthOneStringsInConcatenationVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return;
            }
            String value2 = (String)expression2.getValue();
            if (value2 == null || value2.length() != 1) {
                return;
            }
            if (!ExpressionUtils.isStringConcatenationOperand((PsiExpression)expression2) && !LengthOneStringsInConcatenationVisitor.isArgumentOfStringAppend((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, value2);
        }

        static boolean isArgumentOfStringAppend(PsiExpression expression2) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            if (parent == null) {
                return false;
            }
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandparent = parent.getParent();
            if (!(grandparent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)grandparent;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            if (!"append".equals(name2) && !"insert".equals(name2)) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            String className2 = methodClass.getQualifiedName();
            return "java.lang.StringBuffer".equals(className2) || "java.lang.StringBuilder".equals(className2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection$LengthOneStringsInConcatenationVisitor", "visitLiteralExpression"));
        }
    }

    private static class ReplaceStringsWithCharsFix
    extends InspectionGadgetsFix {
        private ReplaceStringsWithCharsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("length.one.strings.in.concatenation.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceStringsWithCharsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            int length;
            PsiExpression expression2 = (PsiExpression)descriptor.getPsiElement();
            String text2 = expression2.getText();
            String character = text2.substring(1, (length = text2.length()) - 1);
            String charLiteral = "'".equals(character) ? "'\\''" : ("\\\"".equals(character) ? "'\"'" : '\'' + character + '\'');
            PsiReplacementUtil.replaceExpression(expression2, charLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/LengthOneStringsInConcatenationInspection$ReplaceStringsWithCharsFix", "getFamilyName"));
        }
    }
}

