/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ReorderingUtils {
    private static final List<Function<PsiExpression, ExceptionProblem>> PROBLEM_EXTRACTORS = Arrays.asList(NullDereferenceExceptionProblem::from, ClassCastExceptionProblem::from, ArrayIndexExceptionProblem::from, ContractFailExceptionProblem::from);

    public static ThreeState canExtract(@NotNull PsiExpression ancestor, @NotNull PsiExpression expression2) {
        PsiExpression gParent;
        if (ancestor == null) {
            ReorderingUtils.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            ReorderingUtils.$$$reportNull$$$0(1);
        }
        if (expression2 == ancestor) {
            return ThreeState.YES;
        }
        if (PsiUtil.isConstantExpression((PsiExpression)expression2)) {
            return ThreeState.YES;
        }
        PsiExpression parent = (PsiExpression)ObjectUtils.tryCast((Object)expression2.getParent(), PsiExpression.class);
        if (parent instanceof PsiExpressionList && (gParent = (PsiExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiExpression.class)) instanceof PsiCallExpression) {
            Object[] args = ((PsiExpressionList)parent).getExpressions();
            int index = ArrayUtil.indexOf((Object[])args, (Object)expression2);
            ThreeState result = ThreeState.YES;
            for (int i = 0; i < index; ++i) {
                if (!SideEffectChecker.mayHaveSideEffects((PsiExpression)args[i])) continue;
                result = ThreeState.UNSURE;
                break;
            }
            return ReorderingUtils.and(result, () -> ReorderingUtils.canExtract(ancestor, parent));
        }
        if (parent == null) {
            if (PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)expression2, (boolean)true)) {
                return ThreeState.UNSURE;
            }
            throw new IllegalArgumentException("Should be an ancestor");
        }
        if (parent instanceof PsiParenthesizedExpression || parent instanceof PsiInstanceOfExpression || parent instanceof PsiTypeCastExpression) {
            return ReorderingUtils.canExtract(ancestor, parent);
        }
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifierExpression() == expression2) {
            return ReorderingUtils.canExtract(ancestor, parent);
        }
        if (parent instanceof PsiConditionalExpression) {
            ThreeState result;
            PsiConditionalExpression ternary = (PsiConditionalExpression)parent;
            PsiExpression condition2 = ternary.getCondition();
            if (condition2 == expression2) {
                return ReorderingUtils.canExtract(ancestor, parent);
            }
            if (ReorderingUtils.isSideEffectFree(condition2, false) && ReorderingUtils.isSideEffectFree(expression2, false)) {
                result = ThreeState.YES;
            } else {
                boolean isNecessary = ReorderingUtils.areConditionsNecessaryFor(new PsiExpression[]{condition2}, expression2, ternary.getElseExpression() == expression2);
                result = isNecessary ? ThreeState.NO : ThreeState.UNSURE;
            }
            return ReorderingUtils.and(result, () -> ReorderingUtils.canExtract(ancestor, parent));
        }
        if (parent instanceof PsiLambdaExpression) {
            return ThreeState.NO;
        }
        if (parent instanceof PsiUnaryExpression) {
            if (PsiUtil.isIncrementDecrementOperation((PsiElement)parent)) {
                return ThreeState.NO;
            }
            return ReorderingUtils.canExtract(ancestor, parent);
        }
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            Object[] operands2 = polyadic.getOperands();
            int index = ArrayUtil.indexOf((Object[])operands2, (Object)expression2);
            if (index == 0) {
                return ReorderingUtils.canExtract(ancestor, parent);
            }
            IElementType tokenType = polyadic.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) {
                return ReorderingUtils.and(ReorderingUtils.canMoveToStart(polyadic, index), () -> ReorderingUtils.canExtract(ancestor, parent));
            }
            ThreeState result = ThreeState.YES;
            for (int i = 0; i < index; ++i) {
                if (!SideEffectChecker.mayHaveSideEffects((PsiExpression)operands2[i])) continue;
                result = ThreeState.UNSURE;
                break;
            }
            return ReorderingUtils.and(result, () -> ReorderingUtils.canExtract(ancestor, parent));
        }
        if (parent instanceof PsiAssignmentExpression) {
            if (expression2 == ((PsiAssignmentExpression)parent).getLExpression()) {
                return ThreeState.NO;
            }
            return ReorderingUtils.canExtract(ancestor, parent);
        }
        return ReorderingUtils.and(ThreeState.UNSURE, () -> ReorderingUtils.canExtract(ancestor, parent));
    }

    @NotNull
    private static ThreeState and(ThreeState state, Supplier<ThreeState> conjunct) {
        if (state == ThreeState.NO) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(2);
            }
            return threeState;
        }
        ThreeState state2 = conjunct.get();
        if (state2 == ThreeState.NO) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        if (state == ThreeState.UNSURE || state2 == ThreeState.UNSURE) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            ReorderingUtils.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    @NotNull
    private static ThreeState canMoveToStart(PsiPolyadicExpression polyadicExpression, int operandIndex) {
        if (operandIndex == 0) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(6);
            }
            return threeState;
        }
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (tokenType != JavaTokenType.ANDAND && tokenType != JavaTokenType.OROR) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(7);
            }
            return threeState;
        }
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        if (operandIndex < 0 || operandIndex >= operands2.length) {
            throw new IndexOutOfBoundsException("operandIndex = " + operandIndex);
        }
        if (Arrays.stream(operands2, 0, operandIndex + 1).allMatch(expression2 -> ReorderingUtils.isSideEffectFree(expression2, false))) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(8);
            }
            return threeState;
        }
        boolean and = polyadicExpression.getOperationTokenType() == JavaTokenType.ANDAND;
        PsiExpression lastOperand = operands2[operandIndex];
        if (ReorderingUtils.areConditionsNecessaryFor(Arrays.copyOf(operands2, operandIndex), lastOperand, !and)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(9);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            ReorderingUtils.$$$reportNull$$$0(10);
        }
        return threeState;
    }

    private static boolean hasContract(PsiExpression expression2, PsiExpression operand2, ContractReturnValue value2) {
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        if (value2.equals(ContractReturnValue.returnNull()) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(operand2, expression2)) {
            return true;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList.isEmpty()) {
                return false;
            }
            List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
            for (MethodContract methodContract : contracts2) {
                PsiExpression arg;
                PsiExpression[] args;
                ContractValue condition2;
                int argIndex;
                List<ContractValue> conditions;
                if (!methodContract.getReturnValue().equals(value2) || (conditions = methodContract.getConditions()).size() != 1 || (argIndex = (condition2 = conditions.get(0)).getNullCheckedArgument(true).orElse(-1)) < 0 || argIndex >= (args = argumentList.getExpressions()).length || !ReorderingUtils.hasContract(arg = args[argIndex], operand2, ContractReturnValue.returnNull())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    static List<ExceptionProblem> fromExpression(PsiExpression expression2) {
        ArrayList<ExceptionProblem> problems2 = new ArrayList<ExceptionProblem>();
        for (Function<PsiExpression, ExceptionProblem> extractor : PROBLEM_EXTRACTORS) {
            ExceptionProblem exceptionProblem = extractor.apply(expression2);
            if (exceptionProblem == null) continue;
            problems2.add(exceptionProblem);
        }
        ArrayList<ExceptionProblem> arrayList = problems2;
        if (arrayList == null) {
            ReorderingUtils.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static boolean areConditionsNecessaryFor(PsiExpression[] conditions, PsiExpression operand2, boolean negated) {
        List problems2 = SyntaxTraverser.psiTraverser((PsiElement)operand2).traverse().filter(PsiExpression.class).flatMap(ReorderingUtils::fromExpression).filter(Objects::nonNull).toList();
        if (problems2.isEmpty()) {
            return false;
        }
        for (PsiExpression condition2 : conditions) {
            if (!ReorderingUtils.isConditionNecessary(condition2, problems2, negated)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConditionNecessary(PsiExpression condition2, List<ExceptionProblem> problems2, boolean negated) {
        if ((condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)) == null) {
            return false;
        }
        if (BoolUtils.isNegation(condition2)) {
            return ReorderingUtils.isConditionNecessary(BoolUtils.getNegated(condition2), problems2, !negated);
        }
        if (condition2 instanceof PsiPolyadicExpression) {
            IElementType type2 = ((PsiPolyadicExpression)condition2).getOperationTokenType();
            if (type2.equals(JavaTokenType.ANDAND) && !negated || type2.equals(JavaTokenType.OROR) && negated) {
                for (PsiExpression operand2 : ((PsiPolyadicExpression)condition2).getOperands()) {
                    if (!ReorderingUtils.isConditionNecessary(operand2, problems2, negated)) continue;
                    return true;
                }
                return false;
            }
            if (type2.equals(JavaTokenType.ANDAND) && negated || type2.equals(JavaTokenType.OROR) && !negated) {
                for (PsiExpression operand3 : ((PsiPolyadicExpression)condition2).getOperands()) {
                    if (ReorderingUtils.isConditionNecessary(operand3, problems2, negated)) continue;
                    return false;
                }
                return true;
            }
        }
        for (ExceptionProblem problem : problems2) {
            if (!problem.isNecessaryCheck(condition2, negated)) continue;
            return true;
        }
        return false;
    }

    private static boolean isErroneous(PsiElement element) {
        return element instanceof PsiErrorElement || element instanceof PsiLiteralExpression && PsiLiteralUtil.isUnsafeLiteral((PsiLiteralExpression)((PsiLiteralExpression)element));
    }

    public static boolean isSideEffectFree(PsiExpression expression2, boolean allowNpe) {
        return PsiTreeUtil.processElements((PsiElement)expression2, element -> {
            PsiPolyadicExpression expr2;
            PsiType type2;
            if (element instanceof PsiCallExpression || element instanceof PsiArrayAccessExpression || element instanceof PsiTypeCastExpression || ReorderingUtils.isErroneous(element)) {
                return false;
            }
            if (element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) {
                return false;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiExpression qualifier;
                PsiReferenceExpression ref = (PsiReferenceExpression)element;
                if (!allowNpe && (qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)ref.getQualifierExpression())) != null && NullabilityUtil.getExpressionNullability(qualifier) != Nullability.NOT_NULL) {
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiElement target = ((PsiReferenceExpression)qualifier).resolve();
                        return target instanceof PsiClass || target instanceof PsiPackage;
                    }
                    return false;
                }
                type2 = ref.getType();
                PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)ref, false);
                if (type2 != null && !(type2 instanceof PsiPrimitiveType) && expectedType instanceof PsiPrimitiveType) {
                    return false;
                }
            }
            if (element instanceof PsiPolyadicExpression && ((type2 = (expr2 = (PsiPolyadicExpression)element).getOperationTokenType()).equals(JavaTokenType.DIV) || type2.equals(JavaTokenType.PERC))) {
                PsiExpression[] operands2 = expr2.getOperands();
                if (operands2.length != 2) {
                    return false;
                }
                Object divisor = ExpressionUtils.computeConstantExpression(operands2[1]);
                if (!(divisor instanceof Integer) && !(divisor instanceof Long) || ((Number)divisor).longValue() == 0L) {
                    return false;
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ReorderingUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ReorderingUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "canMoveToStart";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canExtract";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ContractFailExceptionProblem
    extends ExceptionProblem {
        private final DfaValueFactory myFactory;
        private final List<DfaRelation> myConditions;

        ContractFailExceptionProblem(DfaValueFactory factory, List<DfaRelation> conditions) {
            super(null);
            this.myFactory = factory;
            this.myConditions = conditions;
        }

        @Override
        boolean isNecessaryCheck(PsiExpression condition2, boolean negated) {
            PsiBinaryExpression binOp;
            RelationType relationType;
            if (condition2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)condition2;
                List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
                if (contracts2.isEmpty()) {
                    return false;
                }
                for (MethodContract methodContract : contracts2) {
                    ContractValue cond;
                    DfaCondition value2;
                    if (!(methodContract.getReturnValue() instanceof ContractReturnValue.BooleanReturnValue)) continue;
                    boolean retValue = ((ContractReturnValue.BooleanReturnValue)methodContract.getReturnValue()).getValue();
                    List<ContractValue> conditions = methodContract.getConditions();
                    if (conditions.size() != 1 || !((value2 = (cond = conditions.get(0)).fromCall(this.myFactory, (PsiCallExpression)call)) instanceof DfaRelation) || !this.myConditions.contains(retValue == negated ? value2 : ((DfaRelation)value2).negate())) continue;
                    return true;
                }
                return false;
            }
            if (condition2 instanceof PsiBinaryExpression && (relationType = RelationType.fromElementType((binOp = (PsiBinaryExpression)condition2).getOperationTokenType())) != null) {
                PsiExpression left = binOp.getLOperand();
                PsiExpression psiExpression = binOp.getROperand();
                DfaValue leftVal = this.myFactory.createValue(left);
                DfaValue rightVal = this.myFactory.createValue(psiExpression);
                if (leftVal == null || rightVal == null) {
                    return false;
                }
                DfaCondition value1 = leftVal.cond(relationType, rightVal);
                DfaCondition value2 = rightVal.cond(Objects.requireNonNull(relationType.getFlipped()), leftVal);
                if (value1 instanceof DfaRelation && this.myConditions.contains(negated ? value1 : ((DfaRelation)value1).negate())) {
                    return true;
                }
                if (value2 instanceof DfaRelation && this.myConditions.contains(negated ? value2 : ((DfaRelation)value2).negate())) {
                    return true;
                }
            }
            return false;
        }

        static ContractFailExceptionProblem from(PsiExpression expression2) {
            if (expression2 instanceof PsiCallExpression) {
                PsiCallExpression call = (PsiCallExpression)expression2;
                PsiMethod method = call.resolveMethod();
                List contracts2 = DfaUtil.addRangeContracts(method, JavaMethodContractUtil.getMethodCallContracts(call));
                if ((contracts2 = ContainerUtil.filter(contracts2, c -> c.getReturnValue().isFail() && c.getConditions().size() == 1)).isEmpty()) {
                    return null;
                }
                DfaValueFactory factory = new DfaValueFactory(expression2.getProject(), null, false);
                ArrayList<DfaRelation> conditions = new ArrayList<DfaRelation>();
                for (MethodContract contract : contracts2) {
                    ContractValue condition2 = contract.getConditions().get(0);
                    DfaCondition conditionValue = condition2.fromCall(factory, call);
                    if (!(conditionValue instanceof DfaRelation)) continue;
                    conditions.add((DfaRelation)conditionValue);
                }
                return new ContractFailExceptionProblem(factory, conditions);
            }
            return null;
        }
    }

    static final class ArrayIndexExceptionProblem
    extends ExceptionProblem {
        private ArrayIndexExceptionProblem(PsiExpression operand2) {
            super(operand2);
        }

        @Override
        boolean isNecessaryCheck(PsiExpression condition2, boolean negated) {
            IElementType token;
            if (condition2 instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation(token = ((PsiBinaryExpression)condition2).getOperationTokenType()) && !token.equals(JavaTokenType.EQEQ) && !token.equals(JavaTokenType.NE)) {
                PsiExpression left = ((PsiBinaryExpression)condition2).getLOperand();
                PsiExpression right = ((PsiBinaryExpression)condition2).getROperand();
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, this.myOperand) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(right, this.myOperand);
            }
            return false;
        }

        static ArrayIndexExceptionProblem from(PsiExpression expression2) {
            if (expression2 instanceof PsiArrayAccessExpression) {
                return new ArrayIndexExceptionProblem(((PsiArrayAccessExpression)expression2).getIndexExpression());
            }
            return null;
        }
    }

    static final class ClassCastExceptionProblem
    extends ExceptionProblem {
        private ClassCastExceptionProblem(PsiExpression operand2) {
            super(operand2);
        }

        @Override
        boolean isNecessaryCheck(PsiExpression condition2, boolean negated) {
            if (negated) {
                return false;
            }
            if (condition2 instanceof PsiInstanceOfExpression) {
                PsiExpression op = ((PsiInstanceOfExpression)condition2).getOperand();
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(op, this.myOperand);
            }
            return false;
        }

        static ClassCastExceptionProblem from(PsiExpression expression2) {
            if (expression2 instanceof PsiTypeCastExpression) {
                return new ClassCastExceptionProblem(((PsiTypeCastExpression)expression2).getOperand());
            }
            return null;
        }
    }

    static final class NullDereferenceExceptionProblem
    extends ExceptionProblem {
        private NullDereferenceExceptionProblem(PsiExpression operand2) {
            super(operand2);
        }

        @Override
        boolean isNecessaryCheck(PsiExpression condition2, boolean negated) {
            IElementType tokenType;
            if (condition2 instanceof PsiBinaryExpression && ((tokenType = ((PsiBinaryExpression)condition2).getOperationTokenType()).equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE))) {
                boolean notNull = negated != tokenType.equals(JavaTokenType.EQEQ);
                ContractReturnValue returnValue = notNull ? ContractReturnValue.returnNotNull() : ContractReturnValue.returnNull();
                PsiExpression left = ((PsiBinaryExpression)condition2).getLOperand();
                PsiExpression right = ((PsiBinaryExpression)condition2).getROperand();
                if (ExpressionUtils.isNullLiteral(left)) {
                    return ReorderingUtils.hasContract(right, this.myOperand, returnValue);
                }
                if (ExpressionUtils.isNullLiteral(right)) {
                    return ReorderingUtils.hasContract(left, this.myOperand, returnValue);
                }
            }
            return ReorderingUtils.hasContract(condition2, this.myOperand, ContractReturnValue.returnBoolean(negated));
        }

        static NullDereferenceExceptionProblem from(PsiExpression expression2) {
            NullabilityProblemKind.NullabilityProblem<?> problem = NullabilityProblemKind.fromContext(expression2, Collections.emptyMap());
            if (problem != null && problem.thrownException() != null) {
                return new NullDereferenceExceptionProblem(expression2);
            }
            return null;
        }
    }

    private static abstract class ExceptionProblem {
        final PsiExpression myOperand;

        ExceptionProblem(PsiExpression operand2) {
            this.myOperand = operand2;
        }

        abstract boolean isNecessaryCheck(PsiExpression var1, boolean var2);
    }
}

