/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ChainedMethodCallInspection
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;
    public boolean m_ignoreThisSuperCalls = true;
    public boolean ignoreSelfTypes = true;

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            ChainedMethodCallInspection.$$$reportNull$$$0(0);
        }
        this.defaultWriteSettings(node, "ignoreSelfTypes");
        this.writeBooleanOption(node, "ignoreSelfTypes", true);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("chained.method.call.ignore.option", new Object[0]), "m_ignoreFieldInitializations");
        panel2.addCheckbox(InspectionGadgetsBundle.message("chained.method.call.ignore.self.types.option", new Object[0]), "ignoreSelfTypes");
        return panel2;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceVariableFix(true);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("chained.method.call.problem.descriptor", new Object[0]);
        if (string == null) {
            ChainedMethodCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedMethodCallVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/ChainedMethodCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/ChainedMethodCallInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ChainedMethodCallVisitor
    extends BaseInspectionVisitor {
        private ChainedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiElement parent;
            PsiElement field;
            if (expression2 == null) {
                ChainedMethodCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression reference = expression2.getMethodExpression();
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(reference.getQualifierExpression());
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiCallExpression)) {
                return;
            }
            if (ChainedMethodCallInspection.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class)) != null) {
                return;
            }
            PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpressionList.class);
            if (expressionList != null && JavaPsiConstructorUtil.isConstructorCall((PsiElement)(parent = expressionList.getParent()))) {
                return;
            }
            if (ChainedMethodCallInspection.this.ignoreSelfTypes) {
                if (qualifier instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifier;
                    PsiMethod qualifierMethod = methodCallExpression.resolveMethod();
                    if (qualifierMethod == null) {
                        return;
                    }
                    PsiClass containingClass = qualifierMethod.getContainingClass();
                    PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierMethod.getReturnType());
                    if (containingClass == null || containingClass.equals(aClass)) {
                        return;
                    }
                }
                PsiClass callClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
                PsiClass qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
                if (qualifierClass == null || qualifierClass.equals(callClass)) {
                    return;
                }
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ChainedMethodCallInspection$ChainedMethodCallVisitor", "visitMethodCallExpression"));
        }
    }
}

