/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MissortedModifiersInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_requireAnnotationsFirst = true;
    public boolean typeUseWithType = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiModifierList modifierList = (PsiModifierList)infos[0];
        String text2 = Stream.of(modifierList.getChildren()).filter(e -> !(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment)).map(PsiElement::getText).collect(Collectors.joining(" "));
        String string = InspectionGadgetsBundle.message("missorted.modifiers.problem.descriptor", text2);
        if (string == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissortedModifiersVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SortModifiersFix();
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(1);
        }
        this.defaultWriteSettings(node, "typeUseWithType");
        this.writeBooleanOption(node, "typeUseWithType", false);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        JCheckBox box = panel2.addCheckboxEx(InspectionGadgetsBundle.message("missorted.modifiers.require.option", new Object[0]), "m_requireAnnotationsFirst");
        panel2.addDependentCheckBox(InspectionGadgetsBundle.message("missorted.modifiers.typeuse.before.type.option", new Object[0]), "typeUseWithType", box);
        return panel2;
    }

    static boolean isMethodWithVoidReturnType(PsiElement element) {
        return element instanceof PsiMethod && PsiType.VOID.equals((Object)((PsiMethod)element).getReturnType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/MissortedModifiersInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/MissortedModifiersInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModifierComparator
    implements Comparator<String> {
        @NonNls
        private static final Map<String, Integer> s_modifierOrder = new HashMap<String, Integer>(12);

        private ModifierComparator() {
        }

        @Override
        public int compare(String modifier1, String modifier2) {
            Integer ordinal1 = s_modifierOrder.get(modifier1);
            Integer ordinal2 = s_modifierOrder.get(modifier2);
            return ordinal1 == null || ordinal2 == null ? 0 : ordinal1 - ordinal2;
        }

        static {
            s_modifierOrder.put("public", 0);
            s_modifierOrder.put("protected", 1);
            s_modifierOrder.put("private", 2);
            s_modifierOrder.put("abstract", 3);
            s_modifierOrder.put("default", 4);
            s_modifierOrder.put("static", 5);
            s_modifierOrder.put("final", 6);
            s_modifierOrder.put("transient", 7);
            s_modifierOrder.put("volatile", 8);
            s_modifierOrder.put("synchronized", 9);
            s_modifierOrder.put("native", 10);
            s_modifierOrder.put("strictfp", 11);
        }
    }

    private class MissortedModifiersVisitor
    extends BaseInspectionVisitor {
        private final Comparator<String> modifierComparator = new ModifierComparator();

        private MissortedModifiersVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            this.checkForMissortedModifiers((PsiModifierListOwner)aClass);
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(1);
            }
            super.visitClassInitializer(initializer);
            this.checkForMissortedModifiers((PsiModifierListOwner)initializer);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(2);
            }
            super.visitLocalVariable(variable);
            this.checkForMissortedModifiers((PsiModifierListOwner)variable);
        }

        public void visitParameter(@NotNull PsiParameter parameter2) {
            if (parameter2 == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(3);
            }
            super.visitParameter(parameter2);
            this.checkForMissortedModifiers((PsiModifierListOwner)parameter2);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(4);
            }
            super.visitMethod(method);
            this.checkForMissortedModifiers((PsiModifierListOwner)method);
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(5);
            }
            super.visitField(field);
            this.checkForMissortedModifiers((PsiModifierListOwner)field);
        }

        private void checkForMissortedModifiers(PsiModifierListOwner listOwner) {
            PsiModifierList modifierList = listOwner.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (!this.isModifierListMissorted(modifierList)) {
                return;
            }
            this.registerError((PsiElement)(this.isVisibleHighlight((PsiElement)modifierList) ? modifierList.getFirstChild() : modifierList), modifierList);
        }

        private boolean isModifierListMissorted(PsiModifierList modifierList) {
            if (modifierList == null) {
                return false;
            }
            String currentModifier = null;
            boolean typeAnnotationSeen = false;
            for (PsiElement child : modifierList.getChildren()) {
                if (child instanceof PsiJavaToken) {
                    if (typeAnnotationSeen) {
                        return true;
                    }
                    String text2 = child.getText();
                    if (this.modifierComparator.compare(text2, currentModifier) < 0) {
                        return true;
                    }
                    currentModifier = text2;
                }
                if (!(child instanceof PsiAnnotation)) continue;
                if (MissortedModifiersInspection.this.m_requireAnnotationsFirst) {
                    PsiAnnotation annotation = (PsiAnnotation)child;
                    if (AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation) && !MissortedModifiersInspection.isMethodWithVoidReturnType(modifierList.getParent())) {
                        PsiAnnotation.TargetType[] targets;
                        if (MissortedModifiersInspection.this.typeUseWithType || currentModifier != null) {
                            typeAnnotationSeen = true;
                        }
                        if (AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{(targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner()))[0]}) != PsiAnnotation.TargetType.UNKNOWN) continue;
                        typeAnnotationSeen = true;
                        continue;
                    }
                    if (!MissortedModifiersInspection.this.m_requireAnnotationsFirst || currentModifier == null) continue;
                    return true;
                }
                if (currentModifier == null) continue;
                typeAnnotationSeen = true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassInitializer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SortModifiersFix
    extends InspectionGadgetsFix {
        private SortModifiersFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("missorted.modifiers.sort.quickfix", new Object[0]);
            if (string == null) {
                SortModifiersFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiModifierList) && !((element = element.getParent()) instanceof PsiModifierList)) {
                return;
            }
            PsiModifierList modifierList = (PsiModifierList)element;
            SmartList modifiers = new SmartList();
            SmartList typeAnnotations = new SmartList();
            SmartList annotations = new SmartList();
            for (PsiElement child : modifierList.getChildren()) {
                if (child instanceof PsiJavaToken) {
                    modifiers.add(child.getText());
                    continue;
                }
                if (!(child instanceof PsiAnnotation)) continue;
                PsiAnnotation annotation = (PsiAnnotation)child;
                if (PsiImplUtil.isTypeAnnotation(child) && !MissortedModifiersInspection.isMethodWithVoidReturnType(modifierList.getParent())) {
                    PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner());
                    if (MissortedModifiersInspection.this.typeUseWithType || !modifiers.isEmpty() || AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{targets[0]}) == PsiAnnotation.TargetType.UNKNOWN) {
                        typeAnnotations.add(child.getText());
                        continue;
                    }
                }
                annotations.add(child.getText());
            }
            Collections.sort(modifiers, new ModifierComparator());
            StringBuilder buffer = new StringBuilder();
            for (String annotation : annotations) {
                buffer.append(annotation).append(' ');
            }
            for (String modifier : modifiers) {
                buffer.append(modifier).append(' ');
            }
            for (String annotation : typeAnnotations) {
                buffer.append(annotation).append(' ');
            }
            buffer.append("void x() {}");
            PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(buffer.toString(), (PsiElement)modifierList);
            PsiModifierList newModifierList = method.getModifierList();
            new CommentTracker().replaceAndRestoreComments((PsiElement)modifierList, (PsiElement)newModifierList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/MissortedModifiersInspection$SortModifiersFix", "getFamilyName"));
        }
    }
}

