/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NestedMethodCallInspection
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;
    public boolean ignoreStaticMethods = false;
    public boolean ignoreGetterCalls = false;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("nested.method.call.ignore.option", new Object[0]), "m_ignoreFieldInitializations");
        panel2.addCheckbox(InspectionGadgetsBundle.message("ignore.calls.to.static.methods", new Object[0]), "ignoreStaticMethods");
        panel2.addCheckbox(InspectionGadgetsBundle.message("ignore.calls.to.property.getters", new Object[0]), "ignoreGetterCalls");
        return panel2;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceVariableFix(false);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.method.call.problem.descriptor", new Object[0]);
        if (string == null) {
            NestedMethodCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedMethodCallVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            NestedMethodCallInspection.$$$reportNull$$$0(1);
        }
        this.defaultWriteSettings(node, "ignoreStaticMethods", "ignoreGetterCalls");
        this.writeBooleanOption(node, "ignoreStaticMethods", false);
        this.writeBooleanOption(node, "ignoreGetterCalls", false);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/NestedMethodCallInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/NestedMethodCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NestedMethodCallVisitor
    extends BaseInspectionVisitor {
        private NestedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiElement field;
            if (expression2 == null) {
                NestedMethodCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiMethodCallExpression outerExpression = expression2;
            while (outerExpression.getParent() instanceof PsiExpression) {
                outerExpression = (PsiExpression)outerExpression.getParent();
            }
            PsiElement parent = outerExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return;
            }
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)grandParent)) {
                return;
            }
            if (NestedMethodCallInspection.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class)) != null) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            if (NestedMethodCallInspection.this.ignoreStaticMethods || NestedMethodCallInspection.this.ignoreGetterCalls) {
                if (NestedMethodCallInspection.this.ignoreStaticMethods && method.hasModifierProperty("static")) {
                    return;
                }
                if (NestedMethodCallInspection.this.ignoreGetterCalls && PropertyUtil.isSimpleGetter(method)) {
                    return;
                }
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/NestedMethodCallInspection$NestedMethodCallVisitor", "visitMethodCallExpression"));
        }
    }
}

