/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ReturnThisInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ReturnOfThis";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("return.this.problem.descriptor", new Object[0]);
        if (string == null) {
            ReturnThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnThisVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ReturnThisInspection", "buildErrorString"));
    }

    private static class ReturnThisVisitor
    extends BaseInspectionVisitor {
        private ReturnThisVisitor() {
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisValue) {
            if (thisValue == null) {
                ReturnThisVisitor.$$$reportNull$$$0(0);
            }
            super.visitThisExpression(thisValue);
            if (thisValue.getQualifier() != null) {
                return;
            }
            PsiElement parent = thisValue.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiTypeCastExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiReturnStatement)) {
                return;
            }
            this.registerError((PsiElement)thisValue, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisValue", "com/siyeh/ig/style/ReturnThisInspection$ReturnThisVisitor", "visitThisExpression"));
        }
    }
}

