/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.style.ConditionalModel;
import com.siyeh.ig.style.IfConditionalModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableIfStatementInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean DONT_WARN_ON_TERNARY = true;
    public boolean DONT_WARN_ON_CHAINED_ID = true;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.option.dont.warn.on.ternary", new Object[0]), "DONT_WARN_ON_TERNARY");
        panel2.addCheckbox(InspectionGadgetsBundle.message("trivial.if.option.ignore.chained", new Object[0]), "DONT_WARN_ON_CHAINED_ID");
        return panel2;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitIfStatement(PsiIfStatement ifStatement) {
                boolean infoLevel;
                IfConditionalModel model = IfConditionalModel.from(ifStatement, false);
                if (model == null) {
                    return;
                }
                String operator2 = SimplifiableIfStatementInspection.getTargetOperator(model);
                if (operator2.isEmpty()) {
                    return;
                }
                boolean bl = infoLevel = operator2.equals("?:") && (SimplifiableIfStatementInspection.this.DONT_WARN_ON_TERNARY || model.getThenExpression() instanceof PsiConditionalExpression || model.getElseExpression() instanceof PsiConditionalExpression) || SimplifiableIfStatementInspection.this.DONT_WARN_ON_CHAINED_ID && ControlFlowUtils.isElseIf(ifStatement);
                if (!isOnTheFly && infoLevel) {
                    return;
                }
                holder.registerProblem(ifStatement.getFirstChild(), InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.message", operator2), infoLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new SimplifiableIfStatementFix(operator2)});
            }
        };
    }

    @NotNull
    private static String getTargetOperator(@NotNull ConditionalModel model) {
        if (model == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(1);
        }
        if (PsiType.BOOLEAN.equals((Object)model.getType())) {
            Boolean value2;
            Boolean elseValue;
            PsiLiteralExpression thenLiteral = ExpressionUtils.getLiteral(model.getThenExpression());
            PsiLiteralExpression elseLiteral = ExpressionUtils.getLiteral(model.getElseExpression());
            Boolean thenValue = thenLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)thenLiteral.getValue(), Boolean.class);
            Boolean bl = elseValue = elseLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)elseLiteral.getValue(), Boolean.class);
            if (thenValue != null && elseValue != null) {
                return "";
            }
            Boolean bl2 = value2 = thenValue == null ? elseValue : thenValue;
            if (value2 != null) {
                return value2 != false ? "||" : "&&";
            }
        }
        return "?:";
    }

    private static String buildExpressionText(@NotNull ConditionalModel model, CommentTracker ct) {
        PsiExpression condition2;
        if (model == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(2);
        }
        if ((condition2 = ParenthesesUtils.stripParentheses(model.getCondition())) == null) {
            return null;
        }
        PsiExpression thenValue = ParenthesesUtils.stripParentheses(model.getThenExpression());
        PsiExpression elseValue = ParenthesesUtils.stripParentheses(model.getElseExpression());
        thenValue = SimplifiableIfStatementInspection.expandDiamondsWhenNeeded(thenValue, model.getType());
        elseValue = SimplifiableIfStatementInspection.expandDiamondsWhenNeeded(elseValue, model.getType());
        if (thenValue == null || elseValue == null) {
            return null;
        }
        if (PsiType.BOOLEAN.equals((Object)model.getType())) {
            Boolean elseBoolean;
            PsiLiteralExpression thenLiteral = ExpressionUtils.getLiteral(thenValue);
            PsiLiteralExpression elseLiteral = ExpressionUtils.getLiteral(elseValue);
            Boolean thenBoolean = thenLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)thenLiteral.getValue(), Boolean.class);
            Boolean bl = elseBoolean = elseLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)elseLiteral.getValue(), Boolean.class);
            if (thenBoolean != null) {
                return thenBoolean != false ? SimplifiableIfStatementInspection.joinConditions(condition2, elseValue, false, ct) : BoolUtils.getNegatedExpressionText(condition2, 13, ct) + "&&" + ct.text(elseValue, 13);
            }
            if (elseBoolean != null) {
                return elseBoolean != false ? BoolUtils.getNegatedExpressionText(condition2, 14, ct) + "||" + ct.text(thenValue, 14) : SimplifiableIfStatementInspection.joinConditions(condition2, thenValue, true, ct);
            }
        }
        StringBuilder conditional = new StringBuilder();
        String conditionText = ct.text(condition2, 15);
        if (condition2 instanceof PsiConditionalExpression) {
            conditional.append('(').append(conditionText).append(')');
        } else {
            conditional.append(conditionText);
        }
        conditional.append('?');
        PsiType thenType = thenValue.getType();
        PsiType elseType = elseValue.getType();
        if (thenType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)thenType) && !(elseType instanceof PsiPrimitiveType) && !(model.getType() instanceof PsiPrimitiveType)) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)thenType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(").append(ct.text((PsiElement)thenValue)).append("):");
            conditional.append(ct.text(elseValue, 15));
        } else if (elseType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)elseType) && !(thenType instanceof PsiPrimitiveType) && !(model.getType() instanceof PsiPrimitiveType)) {
            conditional.append(ct.text(thenValue, 15));
            conditional.append(':');
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)elseType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(").append(ct.text((PsiElement)elseValue)).append(')');
        } else {
            conditional.append(ct.text(thenValue, 15));
            conditional.append(':');
            conditional.append(ct.text(elseValue, 15));
        }
        return conditional.toString();
    }

    public static void tryJoinDeclaration(PsiElement result) {
        if (!(result instanceof PsiExpressionStatement)) {
            return;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)result).getExpression(), PsiAssignmentExpression.class);
        if (assignment == null) {
            return;
        }
        if (!assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
            return;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (ref == null) {
            return;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)result), PsiDeclarationStatement.class);
        if (declaration2 == null) {
            return;
        }
        PsiElement[] elements = declaration2.getDeclaredElements();
        if (elements.length != 1) {
            return;
        }
        PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
        if (var == null || var.getInitializer() != null || !ref.isReferenceTo((PsiElement)var)) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        var.setInitializer(ct.markUnchanged(assignment.getRExpression()));
        ct.deleteAndRestoreComments(result);
    }

    private static PsiExpression expandDiamondsWhenNeeded(PsiExpression thenValue, PsiType requiredType) {
        if (thenValue instanceof PsiNewExpression && !PsiDiamondTypeUtil.canChangeContextForDiamond((PsiNewExpression)thenValue, requiredType)) {
            return PsiDiamondTypeUtil.expandTopLevelDiamondsInside(thenValue);
        }
        return thenValue;
    }

    @NotNull
    private static String joinConditions(PsiExpression left, PsiExpression right, boolean isAnd, CommentTracker ct) {
        IElementType tokenType;
        String token;
        int precedence;
        if (isAnd) {
            precedence = 13;
            token = "&&";
            tokenType = JavaTokenType.ANDAND;
        } else {
            precedence = 14;
            token = "||";
            tokenType = JavaTokenType.OROR;
        }
        PsiPolyadicExpression leftPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)left), PsiPolyadicExpression.class);
        PsiPolyadicExpression rightPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)right), PsiPolyadicExpression.class);
        if (rightPolyadic != null && rightPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ArrayUtil.getFirstElement((Object[])rightPolyadic.getOperands()), left) && !SideEffectChecker.mayHaveSideEffects(left)) {
            String string = ct.text((PsiElement)rightPolyadic);
            if (string == null) {
                SimplifiableIfStatementInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (leftPolyadic != null && leftPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ArrayUtil.getLastElement((Object[])leftPolyadic.getOperands()), right) && !SideEffectChecker.mayHaveSideEffects(right)) {
            String string = ct.text((PsiElement)leftPolyadic);
            if (string == null) {
                SimplifiableIfStatementInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = ct.text(left, precedence) + token + ct.text(right, precedence);
        if (string == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/SimplifiableIfStatementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/SimplifiableIfStatementInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "joinConditions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTargetOperator";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildExpressionText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimplifiableIfStatementFix
    implements LocalQuickFix {
        private final String myOperator;

        SimplifiableIfStatementFix(String operator2) {
            this.myOperator = operator2;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.fix.name", this.myOperator);
            if (string == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.fix.family.name", new Object[0]);
            if (string == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiIfStatement ifStatement;
            if (project == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(3);
            }
            if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiIfStatement.class)) == null) {
                return;
            }
            IfConditionalModel model = IfConditionalModel.from(ifStatement, false);
            if (model == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String conditional = SimplifiableIfStatementInspection.buildExpressionText(model, commentTracker);
            if (conditional == null) {
                return;
            }
            commentTracker.replace((PsiElement)model.getThenExpression(), conditional);
            if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)model.getElseBranch(), (boolean)true)) {
                commentTracker.delete((PsiElement)model.getElseBranch());
            }
            PsiElement result = commentTracker.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)model.getThenBranch());
            SimplifiableIfStatementInspection.tryJoinDeclaration(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/SimplifiableIfStatementInspection$SimplifiableIfStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/SimplifiableIfStatementInspection$SimplifiableIfStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

