/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SynchronizedOnLiteralObjectInspection
extends BaseInspection {
    public boolean warnOnAllPossiblyLiterals = false;
    private static final Set<String> LITERAL_TYPES = ContainerUtil.set((Object[])new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long"});

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typeText = ((PsiType)infos[0]).getPresentableText();
        int message2 = (Integer)infos[1];
        switch (message2) {
            case 1: {
                String string = InspectionGadgetsBundle.message("synchronized.on.literal.object.problem.descriptor", typeText);
                if (string == null) {
                    SynchronizedOnLiteralObjectInspection.$$$reportNull$$$0(0);
                }
                return string;
            }
            case 2: {
                String string = InspectionGadgetsBundle.message("synchronized.on.direct.literal.object.problem.descriptor", typeText);
                if (string == null) {
                    SynchronizedOnLiteralObjectInspection.$$$reportNull$$$0(1);
                }
                return string;
            }
            case 3: {
                String string = InspectionGadgetsBundle.message("synchronized.on.possibly.literal.object.problem.descriptor", typeText);
                if (string == null) {
                    SynchronizedOnLiteralObjectInspection.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        throw new AssertionError();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("synchronized.on.literal.object.warn.on.all.option", new Object[0]), (InspectionProfileEntry)this, "warnOnAllPossiblyLiterals");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizedOnLiteralObjectInspection", "buildErrorString"));
    }

    private class SynchronizeOnLiteralVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLiteralVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                SynchronizeOnLiteralVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression2 = statement.getLockExpression();
            if (lockExpression2 == null) {
                return;
            }
            PsiType type2 = lockExpression2.getType();
            if (type2 == null) {
                return;
            }
            if (!LITERAL_TYPES.contains(type2.getCanonicalText())) {
                return;
            }
            if (!(lockExpression2 instanceof PsiReferenceExpression)) {
                if (ExpressionUtils.isLiteral(lockExpression2)) {
                    this.registerError((PsiElement)lockExpression2, type2, 2);
                } else if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression2, type2, 3);
                }
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression2;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression2, type2, 3);
                }
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            PsiExpression initializer = variable.getInitializer();
            if (!ExpressionUtils.isLiteral(initializer)) {
                if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression2, type2, 3);
                }
                return;
            }
            this.registerError((PsiElement)lockExpression2, type2, 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/SynchronizedOnLiteralObjectInspection$SynchronizeOnLiteralVisitor", "visitSynchronizedStatement"));
        }
    }
}

