/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableHidingMemberVariableInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethods = true;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "LocalVariableHidesMemberVariable";
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.problem.descriptor", aClass.getName());
        if (string == null) {
            LocalVariableHidingMemberVariableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("local.variable.hides.member.variable.ignore.option", new Object[0]), "m_ignoreStaticMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LocalVariableHidingMemberVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection", "buildErrorString"));
    }

    private class LocalVariableHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LocalVariableHidingMemberVariableVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                LocalVariableHidingMemberVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitLocalVariable(variable);
            PsiClass aClass = this.checkFieldNames((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                LocalVariableHidingMemberVariableVisitor.$$$reportNull$$$0(1);
            }
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection) && !(declarationScope instanceof PsiForeachStatement)) {
                return;
            }
            PsiClass aClass = this.checkFieldNames((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldNames(PsiVariable variable) {
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)variable);
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            while (aClass != null) {
                PsiField field = aClass.findFieldByName(variableName, true);
                if (!(field == null || LocalVariableHidingMemberVariableInspection.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass) || LocalVariableHidingMemberVariableInspection.this.m_ignoreStaticMethods && !field.hasModifierProperty("static") && RefactoringUtil.isInStaticContext((PsiElement)variable, aClass))) {
                    return aClass;
                }
                aClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "variable";
            objectArray2[1] = "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspection$LocalVariableHidingMemberVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

