/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.collections;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutableCollectionModelUtils {
    private static final CallMatcher MAP_ENTRY_CALL = CallMatcher.staticCall("java.util.Map", "entry").parameterCount(2);

    ImmutableCollectionModelUtils() {
    }

    @Nullable
    static ImmutableCollectionModel createModel(@NotNull PsiMethodCallExpression call) {
        CollectionType type2;
        if (call == null) {
            ImmutableCollectionModelUtils.$$$reportNull$$$0(0);
        }
        if ((type2 = CollectionType.create(call)) == null) {
            return null;
        }
        if (!ControlFlowUtils.canExtractStatement((PsiExpression)call)) {
            return null;
        }
        String assignedVariable = ImmutableCollectionModelUtils.getAssignedVariable(call);
        PsiExpression[] args = call.getArgumentList().getExpressions();
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)call.getType(), PsiClassType.class);
        if (classType == null) {
            return null;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)call.getProject()).getResolveHelper();
        boolean hasNonResolvedTypeParams = Arrays.stream(classType.getParameters()).map(PsiUtil::resolveClassInClassTypeOnly).anyMatch(aClass -> ImmutableCollectionModelUtils.isNonResolvedTypeParameter(aClass, (PsiElement)call, resolveHelper));
        if (hasNonResolvedTypeParams) {
            return null;
        }
        if ("ofEntries".equals(method.getName()) && Arrays.stream(args).anyMatch(arg -> ImmutableCollectionModelUtils.extractPutArgs(arg) == null)) {
            return null;
        }
        return new ImmutableCollectionModel(call, type2, method, assignedVariable);
    }

    @Contract(value="null, _, _ -> false")
    private static boolean isNonResolvedTypeParameter(@Nullable PsiClass parameter2, @NotNull PsiElement context, @NotNull PsiResolveHelper resolveHelper) {
        if (context == null) {
            ImmutableCollectionModelUtils.$$$reportNull$$$0(1);
        }
        if (resolveHelper == null) {
            ImmutableCollectionModelUtils.$$$reportNull$$$0(2);
        }
        if (!(parameter2 instanceof PsiTypeParameter)) {
            return false;
        }
        PsiTypeParameter typeParameter = (PsiTypeParameter)parameter2;
        String name2 = typeParameter.getName();
        return name2 == null || resolveHelper.resolveReferencedClass(name2, context) != parameter2;
    }

    static void replaceWithMutable(@NotNull ImmutableCollectionModel model, @Nullable Editor editor) {
        if (model == null) {
            ImmutableCollectionModelUtils.$$$reportNull$$$0(3);
        }
        ToMutableCollectionConverter.convert(model, editor);
    }

    @Nullable
    private static String getAssignedVariable(@NotNull PsiMethodCallExpression call) {
        PsiElement parent;
        if (call == null) {
            ImmutableCollectionModelUtils.$$$reportNull$$$0(4);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)call, (Class[])new Class[]{PsiVariable.class, PsiAssignmentExpression.class})) == null) {
            return null;
        }
        if (parent instanceof PsiVariable) {
            PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)parent).getInitializer());
            return initializer == call ? ((PsiVariable)parent).getName() : null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression());
        if (rhs != call) {
            return null;
        }
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)lhs, PsiReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null && SideEffectChecker.mayHaveSideEffects(qualifier)) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
        if (variable == null || variable instanceof PsiField && variable.hasModifierProperty("volatile")) {
            return null;
        }
        return ref.getText();
    }

    @Nullable
    private static String extractPutArgs(@NotNull PsiExpression entryExpression) {
        if (entryExpression == null) {
            ImmutableCollectionModelUtils.$$$reportNull$$$0(5);
        }
        if (entryExpression instanceof PsiReferenceExpression) {
            return MessageFormat.format("{0}.getKey(), {0}.getValue()", entryExpression.getText());
        }
        PsiCallExpression call = (PsiCallExpression)ObjectUtils.tryCast((Object)entryExpression, PsiCallExpression.class);
        if (call == null || !ImmutableCollectionModelUtils.isEntryConstruction(call)) {
            return null;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (expressions2.length == 1) {
            return ImmutableCollectionModelUtils.extractPutArgs(expressions2[0]);
        }
        if (expressions2.length == 2) {
            return expressions2[0].getText() + "," + expressions2[1].getText();
        }
        return null;
    }

    private static boolean isEntryConstruction(@NotNull PsiCallExpression call) {
        if (call == null) {
            ImmutableCollectionModelUtils.$$$reportNull$$$0(6);
        }
        if (MAP_ENTRY_CALL.matches((PsiExpression)call)) {
            return true;
        }
        PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)call, PsiNewExpression.class);
        return newExpression != null && InheritanceUtil.isInheritor((PsiType)newExpression.getType(), (String)"java.util.Map.Entry");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ipp/collections/ImmutableCollectionModelUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNonResolvedTypeParameter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceWithMutable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssignedVariable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractPutArgs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isEntryConstruction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VariableRenamer
    extends VariableInplaceRenamer {
        private final PsiElement myAnchor;

        private VariableRenamer(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull PsiElement anchor) {
            if (elementToRename == null) {
                VariableRenamer.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                VariableRenamer.$$$reportNull$$$0(1);
            }
            if (anchor == null) {
                VariableRenamer.$$$reportNull$$$0(2);
            }
            super(elementToRename, editor);
            this.myAnchor = anchor;
            editor.getCaretModel().moveToOffset(elementToRename.getTextOffset());
        }

        public void finish(boolean success) {
            super.finish(success);
            this.myEditor.getCaretModel().moveToOffset(this.myAnchor.getTextRange().getEndOffset());
        }

        static void rename(@NotNull PsiNamedElement elementToRename, String @NotNull [] names2, @NotNull Editor editor, @NotNull PsiElement anchor) {
            if (elementToRename == null) {
                VariableRenamer.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                VariableRenamer.$$$reportNull$$$0(4);
            }
            if (anchor == null) {
                VariableRenamer.$$$reportNull$$$0(5);
            }
            if (names2 == null) {
                VariableRenamer.$$$reportNull$$$0(6);
            }
            PsiDocumentManager.getInstance((Project)elementToRename.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            LinkedHashSet<String> suggestions = new LinkedHashSet<String>(Arrays.asList(names2));
            new VariableRenamer(elementToRename, editor, anchor).performInplaceRefactoring(suggestions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToRename";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ipp/collections/ImmutableCollectionModelUtils$VariableRenamer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ImmutableCollectionModel {
        private PsiMethodCallExpression myCall;
        private final CollectionType myType;
        private final boolean myIsVarArgCall;
        private final PsiExpression[] myArgs;
        private final String myAssignedVariable;

        @Contract(pure=true)
        ImmutableCollectionModel(@NotNull PsiMethodCallExpression call, @NotNull CollectionType type2, @NotNull PsiMethod method, @Nullable String assignedVariable) {
            if (call == null) {
                ImmutableCollectionModel.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                ImmutableCollectionModel.$$$reportNull$$$0(1);
            }
            if (method == null) {
                ImmutableCollectionModel.$$$reportNull$$$0(2);
            }
            this.myCall = call;
            this.myType = type2;
            this.myIsVarArgCall = !method.isVarArgs() || MethodCallUtils.isVarArgCall((PsiCall)call);
            this.myArgs = call.getArgumentList().getExpressions();
            this.myAssignedVariable = assignedVariable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "call";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/collections/ImmutableCollectionModelUtils$ImmutableCollectionModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToMutableCollectionConverter {
        private final PsiElementFactory myElementFactory;
        private final JavaCodeStyleManager myCodeStyleManager;
        private final Editor myEditor;

        private ToMutableCollectionConverter(@NotNull Project project, @Nullable Editor editor) {
            if (project == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(0);
            }
            this.myElementFactory = PsiElementFactory.getInstance((Project)project);
            this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            this.myEditor = editor;
        }

        private void replaceWithMutable(@NotNull ImmutableCollectionModel model) {
            PsiMethodCallExpression call;
            if (model == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(1);
            }
            if ((call = RefactoringUtil.ensureCodeBlock(model.myCall)) == null) {
                return;
            }
            PsiStatement statement = (PsiStatement)ObjectUtils.tryCast((Object)RefactoringUtil.getParentStatement((PsiElement)call, false), PsiStatement.class);
            if (statement == null) {
                return;
            }
            model.myCall = call;
            String assignedVariable = model.myAssignedVariable;
            if (assignedVariable != null) {
                String initializerText = model.myType.getInitializerText(model.myIsVarArgCall ? null : call.getText());
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, initializerText, new CommentTracker());
                PsiStatement anchor = this.addUpdates(assignedVariable, model, statement);
                if (this.myEditor != null) {
                    this.myEditor.getCaretModel().moveToOffset(anchor.getTextRange().getEndOffset());
                }
            } else {
                this.createVariable(statement, model);
            }
        }

        private void createVariable(@NotNull PsiStatement statement, @NotNull ImmutableCollectionModel model) {
            PsiMethodCallExpression call;
            PsiType type2;
            if (statement == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(2);
            }
            if (model == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(3);
            }
            if ((type2 = (call = model.myCall).getType()) == null) {
                return;
            }
            String[] names2 = this.getNameSuggestions(call, type2);
            if (names2.length == 0) {
                return;
            }
            String name2 = names2[0];
            PsiDeclarationStatement declaration2 = this.createDeclaration(name2, type2, model, statement);
            if (declaration2 == null) {
                return;
            }
            PsiVariable declaredVariable = (PsiVariable)declaration2.getDeclaredElements()[0];
            PsiStatement anchor = this.addUpdates(name2, model, (PsiStatement)declaration2);
            if (call.getParent() instanceof PsiExpressionStatement) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)statement);
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)call, name2, new CommentTracker());
            }
            if (this.myEditor != null) {
                VariableRenamer.rename((PsiNamedElement)declaredVariable, names2, this.myEditor, (PsiElement)anchor);
            }
        }

        @Nullable
        private PsiDeclarationStatement createDeclaration(@NotNull String name2, @NotNull PsiType type2, @NotNull ImmutableCollectionModel model, @NotNull PsiStatement usage) {
            String initializerText;
            PsiExpression initializer;
            PsiType rhsType;
            if (name2 == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(4);
            }
            if (type2 == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(5);
            }
            if (model == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(6);
            }
            if (usage == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(7);
            }
            if ((rhsType = (initializer = this.myElementFactory.createExpressionFromText(initializerText = model.myType.getInitializerText(model.myIsVarArgCall ? null : model.myCall.getText()), null)).getType()) == null) {
                return null;
            }
            if (!TypeUtils.areConvertible(type2, rhsType)) {
                type2 = ExpectedTypeUtils.findExpectedType((PsiExpression)model.myCall, false);
            }
            if (type2 == null) {
                return null;
            }
            PsiDeclarationStatement declaration2 = this.myElementFactory.createVariableDeclarationStatement(name2, type2, initializer);
            return (PsiDeclarationStatement)ObjectUtils.tryCast((Object)BlockUtils.addBefore(usage, new PsiStatement[]{declaration2}), PsiDeclarationStatement.class);
        }

        private String @NotNull [] getNameSuggestions(@NotNull PsiMethodCallExpression call, @NotNull PsiType type2) {
            if (call == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(8);
            }
            if (type2 == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(9);
            }
            String propertyName = this.getPropertyName(call, type2);
            SuggestedNameInfo nameInfo = this.myCodeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, propertyName, (PsiExpression)call, type2);
            if (this.myCodeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)nameInfo, (PsiElement)call, (boolean)true).names == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(10);
            }
            return this.myCodeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)nameInfo, (PsiElement)call, (boolean)true).names;
        }

        @NotNull
        private String getPropertyName(@NotNull PsiMethodCallExpression call, @NotNull PsiType type2) {
            String propertyName;
            if (call == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(11);
            }
            if (type2 == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(12);
            }
            if ((propertyName = ToMutableCollectionConverter.getPropertyNameByCall(call)) != null) {
                String string = propertyName;
                if (string == null) {
                    ToMutableCollectionConverter.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = this.myCodeStyleManager.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)type2).names[0];
            if (string == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(14);
            }
            return string;
        }

        @NotNull
        private PsiStatement addUpdates(@NotNull String variable, @NotNull ImmutableCollectionModel model, @NotNull PsiStatement anchor) {
            if (variable == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(15);
            }
            if (model == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(16);
            }
            if (anchor == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(17);
            }
            if (!model.myIsVarArgCall) {
                PsiStatement psiStatement = anchor;
                if (psiStatement == null) {
                    ToMutableCollectionConverter.$$$reportNull$$$0(18);
                }
                return psiStatement;
            }
            PsiStatement psiStatement = (PsiStatement)StreamEx.of(ToMutableCollectionConverter.createUpdates(variable, model)).map(update2 -> this.myElementFactory.createStatementFromText(update2, null)).foldLeft((Object)anchor, (acc, update2) -> BlockUtils.addAfter(acc, update2));
            if (psiStatement == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(19);
            }
            return psiStatement;
        }

        @NotNull
        private static List<String> createUpdates(@NotNull String name2, @NotNull ImmutableCollectionModel model) {
            if (name2 == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(20);
            }
            if (model == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(21);
            }
            boolean isMapOfEntriesCall = "ofEntries".equals(model.myCall.getMethodExpression().getReferenceName());
            ArrayList<String> updates = new ArrayList<String>();
            PsiExpression[] args = model.myArgs;
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = args[i];
                if (model.myType != CollectionType.MAP) {
                    updates.add(String.format("%s.add(%s);", name2, arg.getText()));
                    continue;
                }
                if (isMapOfEntriesCall) {
                    updates.add(String.format("%s.put(%s);", name2, ImmutableCollectionModelUtils.extractPutArgs(arg)));
                    continue;
                }
                if (i % 2 == 0) continue;
                updates.add(String.format("%s.put(%s, %s);", name2, args[i - 1].getText(), arg.getText()));
            }
            ArrayList<String> arrayList = updates;
            if (arrayList == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(22);
            }
            return arrayList;
        }

        @Nullable
        private static String getPropertyNameByCall(@NotNull PsiMethodCallExpression call) {
            PsiMethodCallExpression outerCall;
            if (call == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(23);
            }
            if ((outerCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethodCallExpression.class)) == null) {
                return null;
            }
            PsiMethod method = outerCall.resolveMethod();
            if (method == null) {
                return null;
            }
            PsiExpression[] arguments = outerCall.getArgumentList().getExpressions();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (parameters2.length == 0) {
                return null;
            }
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] != call) continue;
                int idx = i >= parameters2.length ? parameters2.length - 1 : i;
                return parameters2[idx].getName();
            }
            return null;
        }

        static void convert(@NotNull ImmutableCollectionModel model, @Nullable Editor editor) {
            if (model == null) {
                ToMutableCollectionConverter.$$$reportNull$$$0(24);
            }
            new ToMutableCollectionConverter(model.myCall.getProject(), editor).replaceWithMutable(model);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 13: 
                case 14: 
                case 18: 
                case 19: 
                case 22: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 13: 
                case 14: 
                case 18: 
                case 19: 
                case 22: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 16: 
                case 21: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 4: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 8: 
                case 11: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 10: 
                case 13: 
                case 14: 
                case 18: 
                case 19: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ipp/collections/ImmutableCollectionModelUtils$ToMutableCollectionConverter";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ipp/collections/ImmutableCollectionModelUtils$ToMutableCollectionConverter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameSuggestions";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPropertyName";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addUpdates";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUpdates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceWithMutable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createVariable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createDeclaration";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getNameSuggestions";
                    break;
                }
                case 10: 
                case 13: 
                case 14: 
                case 18: 
                case 19: 
                case 22: {
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getPropertyName";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "addUpdates";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "createUpdates";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "getPropertyNameByCall";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 13: 
                case 14: 
                case 18: 
                case 19: 
                case 22: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum CollectionType {
        MAP("java.util.HashMap"),
        LIST("java.util.ArrayList"),
        SET("java.util.HashSet");

        private final String myMutableClass;
        private static final CallMapper<CollectionType> MAPPER;

        private CollectionType(String className2) {
            this.myMutableClass = className2;
        }

        @NotNull
        String getInitializerText(@Nullable String copyFrom) {
            String string = String.format("new " + this.myMutableClass + "<>(%s)", StringUtil.notNullize((String)copyFrom));
            if (string == null) {
                CollectionType.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        static CollectionType create(@NotNull PsiMethodCallExpression call) {
            CollectionType type2;
            if (call == null) {
                CollectionType.$$$reportNull$$$0(1);
            }
            if ((type2 = MAPPER.mapFirst(call)) == null) {
                return null;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)call, false);
            if (expectedType == null) {
                return null;
            }
            PsiClassType newType = TypeUtils.getType(type2.myMutableClass, (PsiElement)call);
            return expectedType.isAssignableFrom((PsiType)newType) ? type2 : null;
        }

        static {
            MAPPER = new CallMapper<CollectionType>().register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "emptyMap").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "singletonMap").parameterCount(2), CallMatcher.staticCall("java.util.Map", "of"), CallMatcher.staticCall("java.util.Map", "ofEntries"), CallMatcher.staticCall("com.google.common.collect.ImmutableMap", "of")), MAP).register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "emptyList").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "singletonList").parameterCount(1), CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("com.google.common.collect.ImmutableList", "of")), LIST).register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "emptySet").parameterCount(0), CallMatcher.staticCall("java.util.Collections", "singleton").parameterCount(1), CallMatcher.staticCall("java.util.Set", "of"), CallMatcher.staticCall("com.google.common.collect.ImmutableSet", "of")), SET);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ipp/collections/ImmutableCollectionModelUtils$CollectionType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitializerText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ipp/collections/ImmutableCollectionModelUtils$CollectionType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

