/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.StringConcatPredicate;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JoinConcatenatedStringLiteralsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new StringConcatPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            JoinConcatenatedStringLiteralsIntention.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        PsiJavaToken token = (PsiJavaToken)element;
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        StringBuilder newExpression = new StringBuilder();
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        for (int i = 0; i < operands2.length; ++i) {
            PsiElement nextSibling;
            PsiExpression operand2 = operands2[i];
            if (polyadicExpression.getTokenBeforeOperand(operand2) != token) continue;
            PsiExpression prev = operands2[i - 1];
            for (nextSibling = polyadicExpression.getFirstChild(); nextSibling != prev; nextSibling = nextSibling.getNextSibling()) {
                newExpression.append(tracker.text(nextSibling));
            }
            JoinConcatenatedStringLiteralsIntention.merge((PsiLiteralExpressionImpl)prev, (PsiLiteralExpressionImpl)operand2, newExpression);
            for (nextSibling = operand2.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                newExpression.append(tracker.text(nextSibling));
            }
            break;
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString(), tracker);
    }

    private static void merge(PsiLiteralExpressionImpl left, PsiLiteralExpressionImpl right, StringBuilder newExpression) {
        String leftText = Objects.requireNonNull(left.getValue()).toString();
        String rightText = Objects.requireNonNull(right.getValue()).toString();
        if (left.getLiteralElementType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
            String indent = StringUtil.repeat((String)" ", (int)left.getTextBlockIndent());
            newExpression.append("\"\"\"").append('\n').append(indent);
            newExpression.append(leftText.replaceAll("\n", "\n" + indent));
            if (right.getLiteralElementType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
                newExpression.append(rightText.replaceAll("\n", "\n" + indent));
            } else {
                newExpression.append(StringUtil.escapeStringCharacters((String)rightText));
            }
            newExpression.append("\"\"\"");
        } else if (right.getLiteralElementType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
            String indent = StringUtil.repeat((String)" ", (int)right.getTextBlockIndent());
            newExpression.append("\"\"\"").append('\n').append(indent);
            newExpression.append(StringUtil.escapeStringCharacters((String)leftText));
            newExpression.append(rightText.replaceAll("\n", "\n" + indent));
            newExpression.append("\"\"\"");
        } else {
            newExpression.append('\"');
            newExpression.append(StringUtil.escapeStringCharacters((String)leftText));
            newExpression.append(StringUtil.escapeStringCharacters((String)rightText));
            newExpression.append('\"');
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/concatenation/JoinConcatenatedStringLiteralsIntention", "processIntention"));
    }
}

