/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.codeInsight.intention.numeric.AbstractNumberConversionIntention;
import com.intellij.codeInsight.intention.numeric.NumberConverter;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ipp.integer.JavaNumberConverters;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNumberConversionIntention
extends AbstractNumberConversionIntention {
    private static final ImmutableList<NumberConverter> JAVA_1_CONVERTERS = ContainerUtil.immutableList((Object[])new NumberConverter[]{JavaNumberConverters.INTEGER_TO_DECIMAL, JavaNumberConverters.INTEGER_TO_HEX, JavaNumberConverters.INTEGER_TO_OCTAL, JavaNumberConverters.FLOAT_TO_DECIMAL, JavaNumberConverters.FLOAT_TO_PLAIN, JavaNumberConverters.FLOAT_TO_SCIENTIFIC});
    private static final ImmutableList<NumberConverter> JAVA_5_CONVERTERS = ContainerUtil.immutableList((Object[])new NumberConverter[]{JavaNumberConverters.INTEGER_TO_DECIMAL, JavaNumberConverters.INTEGER_TO_HEX, JavaNumberConverters.INTEGER_TO_OCTAL, JavaNumberConverters.FLOAT_TO_DECIMAL, JavaNumberConverters.FLOAT_TO_PLAIN, JavaNumberConverters.FLOAT_TO_SCIENTIFIC, JavaNumberConverters.FLOAT_TO_HEX});
    private static final ImmutableList<NumberConverter> JAVA_7_CONVERTERS = ContainerUtil.immutableList((Object[])new NumberConverter[]{JavaNumberConverters.INTEGER_TO_DECIMAL, JavaNumberConverters.INTEGER_TO_HEX, JavaNumberConverters.INTEGER_TO_BINARY, JavaNumberConverters.INTEGER_TO_OCTAL, JavaNumberConverters.FLOAT_TO_DECIMAL, JavaNumberConverters.FLOAT_TO_PLAIN, JavaNumberConverters.FLOAT_TO_SCIENTIFIC, JavaNumberConverters.FLOAT_TO_HEX});

    @Nullable
    @Contract(pure=true)
    protected AbstractNumberConversionIntention.NumberConversionContext extract(@NotNull PsiElement element) {
        PsiLiteralExpression literal;
        if (element == null) {
            JavaNumberConversionIntention.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiJavaToken) {
            element = element.getParent();
        }
        if ((literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)element, PsiLiteralExpression.class)) == null) {
            return null;
        }
        Number value2 = (Number)ObjectUtils.tryCast((Object)literal.getValue(), Number.class);
        if (value2 == null) {
            return null;
        }
        if (ExpressionUtils.isNegative((PsiExpression)literal)) {
            value2 = Objects.requireNonNull(JavaPsiMathUtil.negate(value2));
            return new AbstractNumberConversionIntention.NumberConversionContext(element.getParent(), value2, literal.getText(), true);
        }
        return new AbstractNumberConversionIntention.NumberConversionContext(element, value2, literal.getText(), false);
    }

    @NotNull
    @Contract(pure=true)
    protected List<NumberConverter> getConverters(@NotNull PsiFile file) {
        if (file == null) {
            JavaNumberConversionIntention.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PsiJavaFile)) {
            List<NumberConverter> list = Collections.emptyList();
            if (list == null) {
                JavaNumberConversionIntention.$$$reportNull$$$0(2);
            }
            return list;
        }
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)file);
        if (level.isLessThan(LanguageLevel.JDK_1_5)) {
            ImmutableList<NumberConverter> immutableList = JAVA_1_CONVERTERS;
            if (immutableList == null) {
                JavaNumberConversionIntention.$$$reportNull$$$0(3);
            }
            return immutableList;
        }
        if (level.isLessThan(LanguageLevel.JDK_1_7)) {
            ImmutableList<NumberConverter> immutableList = JAVA_5_CONVERTERS;
            if (immutableList == null) {
                JavaNumberConversionIntention.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        ImmutableList<NumberConverter> immutableList = JAVA_7_CONVERTERS;
        if (immutableList == null) {
            JavaNumberConversionIntention.$$$reportNull$$$0(5);
        }
        return immutableList;
    }

    protected void replace(PsiElement sourceElement, String replacement) {
        new CommentTracker().replaceAndRestoreComments(sourceElement, replacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/integer/JavaNumberConversionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/integer/JavaNumberConversionIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConverters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConverters";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

