/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library.propertiesEditor;

import com.google.common.base.Strings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.idea.maven.aether.ArtifactKind;

public class RepositoryLibraryPropertiesModel {
    private String version;
    private final EnumSet<ArtifactKind> myArtifactKinds = EnumSet.noneOf(ArtifactKind.class);
    private boolean includeTransitiveDependencies;
    private List<String> myExcludedDependencies;

    public RepositoryLibraryPropertiesModel(String version, boolean downloadSources, boolean downloadJavaDocs) {
        this(version, downloadSources, downloadJavaDocs, true, ContainerUtil.emptyList());
    }

    public RepositoryLibraryPropertiesModel(String version, boolean downloadSources, boolean downloadJavaDocs, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this(version, ArtifactKind.kindsOf((boolean)downloadSources, (boolean)downloadJavaDocs, (String[])new String[0]), includeTransitiveDependencies, excludedDependencies);
    }

    public RepositoryLibraryPropertiesModel(String version, EnumSet<ArtifactKind> artifactKinds, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this.version = version;
        this.myArtifactKinds.addAll(artifactKinds);
        this.includeTransitiveDependencies = includeTransitiveDependencies;
        this.myExcludedDependencies = new ArrayList<String>(excludedDependencies);
    }

    public RepositoryLibraryPropertiesModel clone() {
        return new RepositoryLibraryPropertiesModel(this.version, this.myArtifactKinds, this.includeTransitiveDependencies, new ArrayList<String>(this.myExcludedDependencies));
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.version);
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    public void setIncludeTransitiveDependencies(boolean includeTransitiveDependencies) {
        this.includeTransitiveDependencies = includeTransitiveDependencies;
    }

    public List<String> getExcludedDependencies() {
        return this.myExcludedDependencies;
    }

    public void setExcludedDependencies(Collection<String> excludedDependencies) {
        this.myExcludedDependencies = new ArrayList<String>(excludedDependencies);
    }

    public boolean isDownloadSources() {
        return this.myArtifactKinds.contains(ArtifactKind.SOURCES);
    }

    public void setDownloadSources(boolean downloadSources) {
        if (downloadSources) {
            this.myArtifactKinds.add(ArtifactKind.SOURCES);
        } else {
            this.myArtifactKinds.remove(ArtifactKind.SOURCES);
        }
    }

    public boolean isDownloadJavaDocs() {
        return this.myArtifactKinds.contains(ArtifactKind.JAVADOC);
    }

    public void setDownloadJavaDocs(boolean downloadJavaDocs) {
        if (downloadJavaDocs) {
            this.myArtifactKinds.add(ArtifactKind.JAVADOC);
        } else {
            this.myArtifactKinds.remove(ArtifactKind.JAVADOC);
        }
    }

    public boolean isDownloadAnnotations() {
        return this.myArtifactKinds.contains(ArtifactKind.ANNOTATIONS);
    }

    public void setDownloadAnnotations(boolean downloadAnnotations) {
        if (downloadAnnotations) {
            this.myArtifactKinds.add(ArtifactKind.ANNOTATIONS);
        } else {
            this.myArtifactKinds.remove(ArtifactKind.ANNOTATIONS);
        }
    }

    public EnumSet<ArtifactKind> getArtifactKinds() {
        return EnumSet.copyOf(this.myArtifactKinds);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryLibraryPropertiesModel model = (RepositoryLibraryPropertiesModel)o;
        if (!this.myArtifactKinds.equals(model.myArtifactKinds)) {
            return false;
        }
        if (this.includeTransitiveDependencies != model.includeTransitiveDependencies) {
            return false;
        }
        if (this.version != null ? !this.version.equals(model.version) : model.version != null) {
            return false;
        }
        return this.myExcludedDependencies.equals(model.myExcludedDependencies);
    }

    public int hashCode() {
        int result = this.myArtifactKinds.hashCode();
        result = 31 * result + (this.includeTransitiveDependencies ? 1 : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + this.myExcludedDependencies.hashCode();
        return result;
    }
}

