/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.template;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesState;

public abstract class TemplatesManager
implements PersistentStateComponent<TemplatesState> {
    public static final Key<Map<String, PsiType>> TEMPLATE_IMPLICITS = Key.create((String)"TEMPLATE_IMPLICITS");
    private TemplatesState myState = new TemplatesState();

    public abstract TemplateResource[] getDefaultTemplates();

    protected static String readFile(String resource, Class<? extends TemplatesManager> templatesManagerClass) throws IOException {
        BufferedInputStream in = new BufferedInputStream(templatesManagerClass.getResourceAsStream(resource));
        return StringUtil.convertLineSeparators((String)FileUtil.loadTextAndClose((Reader)new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)));
    }

    public TemplatesState getState() {
        return this.myState;
    }

    public void loadState(@NotNull TemplatesState state) {
        if (state == null) {
            TemplatesManager.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    public void addTemplate(TemplateResource template) {
        this.myState.templates.add(template);
    }

    public void removeTemplate(TemplateResource template) {
        Iterator<TemplateResource> it = this.myState.templates.iterator();
        while (it.hasNext()) {
            TemplateResource resource = it.next();
            if (!Comparing.equal((String)resource.getFileName(), (String)template.getFileName())) continue;
            it.remove();
        }
    }

    public Collection<TemplateResource> getAllTemplates() {
        HashSet<String> names2 = new HashSet<String>();
        LinkedHashSet<TemplateResource> templates = new LinkedHashSet<TemplateResource>(Arrays.asList(this.getDefaultTemplates()));
        for (TemplateResource template : this.myState.templates) {
            if (!names2.add(template.getFileName())) continue;
            templates.add(template);
        }
        return templates;
    }

    public TemplateResource getDefaultTemplate() {
        TemplateResource resource = this.findTemplateByName(this.myState.defaultTempalteName);
        if (resource != null) {
            return resource;
        }
        String initialTemplateName = this.getInitialTemplateName();
        resource = initialTemplateName != null ? this.findTemplateByName(initialTemplateName) : null;
        return (TemplateResource)ObjectUtils.notNull((Object)resource, (Object)this.getAllTemplates().iterator().next());
    }

    protected String getInitialTemplateName() {
        return null;
    }

    @Nullable
    public TemplateResource findTemplateByName(String templateName) {
        for (TemplateResource template : this.getAllTemplates()) {
            if (!Comparing.equal((String)template.getFileName(), (String)templateName)) continue;
            return template;
        }
        return null;
    }

    public void setDefaultTemplate(TemplateResource res) {
        this.myState.defaultTempalteName = res.getFileName();
    }

    public void setTemplates(List<? extends TemplateResource> items) {
        this.myState.templates.clear();
        for (TemplateResource templateResource : items) {
            if (templateResource.isDefault()) continue;
            this.myState.templates.add(templateResource);
        }
    }

    @NotNull
    public static PsiType createFieldListElementType(Project project) {
        PsiClass[] classes2;
        PsiType classType = TemplatesManager.createElementType(project, FieldElement.class);
        for (PsiClass listClass : classes2 = JavaPsiFacade.getInstance((Project)project).findClasses("java.util.List", GlobalSearchScope.allScope((Project)project))) {
            if (listClass.getTypeParameters().length != 1) continue;
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)project).createType(listClass, classType);
            if (psiClassType == null) {
                TemplatesManager.$$$reportNull$$$0(1);
            }
            return psiClassType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
        if (psiPrimitiveType == null) {
            TemplatesManager.$$$reportNull$$$0(2);
        }
        return psiPrimitiveType;
    }

    @NotNull
    public static PsiType createElementType(Project project, Class<?> elementClass) {
        List methodNames = ContainerUtil.mapNotNull((Object[])elementClass.getMethods(), method -> {
            String methodName = method.getName();
            if (methodName.startsWith("set") || method.isSynthetic() || method.isBridge()) {
                return null;
            }
            String parametersString2 = StringUtil.join((Object[])method.getParameters(), param -> param.getParameterizedType().getTypeName() + " " + param.getName(), (String)", ");
            return method.getGenericReturnType().getTypeName() + " " + methodName + "(" + parametersString2 + ");";
        });
        String text2 = "interface " + elementClass.getSimpleName() + " {\n" + StringUtil.join((Collection)methodNames, (String)"\n") + "}";
        PsiClass aClass = JavaPsiFacade.getElementFactory((Project)project).createClassFromText(text2, null).getInnerClasses()[0];
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)project).createType(aClass);
        if (psiClassType == null) {
            TemplatesManager.$$$reportNull$$$0(3);
        }
        return psiClassType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/generate/template/TemplatesManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/generate/template/TemplatesManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldListElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

